/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.secret;

import io.camunda.connector.api.secret.SecretProvider;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class EnvironmentSecretProvider
implements SecretProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentSecretProvider.class);
    private final Environment environment;
    private final String prefix;

    public EnvironmentSecretProvider(Environment environment, String prefix) {
        this.environment = environment;
        this.prefix = prefix;
    }

    @PostConstruct
    public void init() {
        if (!StringUtils.hasText((String)this.prefix)) {
            LOG.info("No prefix has been configured, all environment variables are available as connector secrets");
        } else {
            LOG.debug("Prefix '{}' has been configured, only environment variables with this prefix are available as connector secrets", (Object)this.prefix);
        }
    }

    public String getSecret(String name) {
        String prefixedName = !StringUtils.hasText((String)this.prefix) ? name : this.prefix + name;
        return this.environment.getProperty(prefixedName);
    }
}

