/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.util.discovery;

import io.camunda.connector.impl.ConnectorUtil;
import io.camunda.connector.impl.inbound.InboundConnectorConfiguration;
import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnvVarsConnectorDiscovery {
    public static final Pattern OUTBOUND_CONNECTOR_FUNCTION_PATTERN = Pattern.compile("^CONNECTOR_(.*)_FUNCTION$");
    public static final Pattern INBOUND_CONNECTOR_EXECUTABLE_PATTERN = Pattern.compile("^CONNECTOR_(.*)_EXECUTABLE$");
    private static Map<String, String> hardwiredEnvironmentVariables;

    public static void addHardwiredEnvironmentVariable(String key, String value) {
        if (hardwiredEnvironmentVariables == null) {
            hardwiredEnvironmentVariables = new ConcurrentHashMap<String, String>();
        }
        hardwiredEnvironmentVariables.put(key, value);
    }

    public static void clearHardwiredEnvironmentVariable() {
        hardwiredEnvironmentVariables = null;
    }

    public static Map<String, String> getEnvironmentVariables() {
        if (hardwiredEnvironmentVariables != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.putAll(System.getenv());
            result.putAll(hardwiredEnvironmentVariables);
            return result;
        }
        return System.getenv();
    }

    public static boolean isInboundConfigured() {
        return EnvVarsConnectorDiscovery.getEnvironmentVariables().entrySet().stream().anyMatch(entry -> INBOUND_CONNECTOR_EXECUTABLE_PATTERN.matcher((CharSequence)entry.getKey()).matches());
    }

    public static boolean isOutboundConfigured() {
        return EnvVarsConnectorDiscovery.getEnvironmentVariables().entrySet().stream().anyMatch(entry -> OUTBOUND_CONNECTOR_FUNCTION_PATTERN.matcher((CharSequence)entry.getKey()).matches());
    }

    public static List<OutboundConnectorConfiguration> discoverOutbound() {
        return EnvVarsConnectorDiscovery.matchEnvVars(OUTBOUND_CONNECTOR_FUNCTION_PATTERN).map(EnvVarsConnectorDiscovery::loadOutboundConfiguration).collect(Collectors.toList());
    }

    public static List<InboundConnectorConfiguration> discoverInbound() {
        return EnvVarsConnectorDiscovery.matchEnvVars(INBOUND_CONNECTOR_EXECUTABLE_PATTERN).map(EnvVarsConnectorDiscovery::loadInboundConfiguration).collect(Collectors.toList());
    }

    private static Stream<String> matchEnvVars(Pattern pattern) {
        return EnvVarsConnectorDiscovery.getEnvironmentVariables().keySet().stream().map(pattern::matcher).filter(Matcher::matches).map(match -> match.group(1));
    }

    private static OutboundConnectorConfiguration loadOutboundConfiguration(String name) {
        String functionFqdn = EnvVarsConnectorDiscovery.getEnv(name, "FUNCTION").orElseThrow(() -> EnvVarsConnectorDiscovery.envMissing("No function specified", name, "FUNCTION"));
        try {
            Class<?> cls = Class.forName(functionFqdn);
            Optional annotationConfig = ConnectorUtil.getOutboundConnectorConfiguration(cls);
            return new OutboundConnectorConfiguration(name, EnvVarsConnectorDiscovery.getEnv(name, "INPUT_VARIABLES").map(variables -> variables.split(",")).or(() -> annotationConfig.map(OutboundConnectorConfiguration::getInputVariables)).orElseThrow(() -> EnvVarsConnectorDiscovery.envMissing("Variables not specified", name, "INPUT_VARIABLES")), EnvVarsConnectorDiscovery.getEnv(name, "TYPE").or(() -> annotationConfig.map(OutboundConnectorConfiguration::getType)).orElseThrow(() -> EnvVarsConnectorDiscovery.envMissing("Type not specified", name, "TYPE")), cls);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw EnvVarsConnectorDiscovery.loadFailed("Failed to load " + functionFqdn, e);
        }
    }

    private static InboundConnectorConfiguration loadInboundConfiguration(String name) {
        String executableFqdn = EnvVarsConnectorDiscovery.getEnv(name, "EXECUTABLE").orElseThrow(() -> EnvVarsConnectorDiscovery.envMissing("No executable specified", name, "EXECUTABLE"));
        try {
            Class<?> cls = Class.forName(executableFqdn);
            Optional annotationConfig = ConnectorUtil.getInboundConnectorConfiguration(cls);
            return new InboundConnectorConfiguration(name, EnvVarsConnectorDiscovery.getEnv(name, "TYPE").or(() -> annotationConfig.map(InboundConnectorConfiguration::getType)).orElseThrow(() -> EnvVarsConnectorDiscovery.envMissing("Type not specified", name, "TYPE")), cls);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw EnvVarsConnectorDiscovery.loadFailed("Failed to load " + executableFqdn, e);
        }
    }

    private static Optional<String> getEnv(String name, String detail) {
        return Optional.ofNullable(EnvVarsConnectorDiscovery.getEnvironmentVariables().get("CONNECTOR_" + name + "_" + detail));
    }

    private static RuntimeException loadFailed(String s, Exception e) {
        return new IllegalStateException(s, e);
    }

    private static RuntimeException envMissing(String message, String name, String envKey) {
        return new RuntimeException(String.format("%s: Please configure it via CONNECTOR_%s_%s environment variable", message, name, envKey));
    }
}

