/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.generic;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import io.camunda.identity.sdk.utility.UrlQueryString;
import java.net.URI;

public class GenericAuthorizeUriBuilder
extends AuthorizeUriBuilder {
    protected final IdentityConfiguration configuration;
    private final String authorizeEndpoint;
    private final String redirectUri;

    public GenericAuthorizeUriBuilder(IdentityConfiguration configuration, String authorizeEndpoint, String redirectUri) {
        this.configuration = configuration;
        this.authorizeEndpoint = authorizeEndpoint;
        this.redirectUri = redirectUri;
    }

    @Override
    public URI build() {
        UrlQueryString query = new UrlQueryString().add("client_id", this.configuration.getClientId()).add("redirect_uri", this.redirectUri).add("response_type", "code").add("scope", this.buildScopes());
        if (this.state != null) {
            query.add("state", this.state);
        }
        if (this.configuration.getAudience() != null) {
            query.add("audience", this.configuration.getAudience());
        }
        return URI.create(String.format("%s?%s", this.authorizeEndpoint, query.toString()));
    }

    protected String buildScopes() {
        return "openid email offline_access";
    }
}

