/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.utility;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class UrlUtility {
    public static String combinePaths(String ... paths) {
        return IntStream.range(0, paths.length).filter(i -> paths[i] != null).mapToObj(i -> {
            String path = paths[i];
            if (i > 0 && !path.isEmpty() && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (i < paths.length - 1 && !path.isEmpty() && path.charAt(path.length() - 1) == '/') {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }).filter(path -> !path.isEmpty()).collect(Collectors.joining("/"));
    }

    public static String encodeQueryParameter(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }
}

