/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.cache;

import com.auth0.jwt.JWT;
import io.camunda.identity.sdk.authentication.Tokens;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.ehcache.expiry.ExpiryPolicy;

public class ClientTokenCacheExpiryPolicy implements ExpiryPolicy<String, Tokens> {
  private static final long TOKEN_MIN_VALIDITY_SECONDS = 30;

  @Override
  public Duration getExpiryForCreation(final String audience, final Tokens tokens) {
    Instant tokenExpiry = Instant.ofEpochMilli(
        JWT.decode(tokens.getAccessToken())
            .getExpiresAt()
            .getTime()
    ).minusSeconds(TOKEN_MIN_VALIDITY_SECONDS);
    long tokenExpiryDuration = Instant.now().until(tokenExpiry, ChronoUnit.MILLIS);

    return Duration.ofMillis(tokenExpiryDuration);
  }

  @Override
  public Duration getExpiryForAccess(final String s, final Supplier<? extends Tokens> supplier) {
    return null;
  }

  @Override
  public Duration getExpiryForUpdate(
      final String s,
      final Supplier<? extends Tokens> supplier,
      final Tokens tokens
  ) {
    return null;
  }
}
