/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk;

import org.apache.commons.lang3.Validate;

public class IdentityConfiguration {
    private final String baseUrl;
    private final String issuer;
    private final String issuerBackendUrl;
    private final String clientId;
    private final String clientSecret;
    private final String audience;
    private final Type type;
    private final String authScopes;

    public IdentityConfiguration(String issuer, String issuerBackendUrl, String clientId, String clientSecret, String audience) {
        this(null, issuer, issuerBackendUrl, clientId, clientSecret, audience, Type.KEYCLOAK, null);
    }

    public IdentityConfiguration(String issuer, String issuerBackendUrl, String clientId, String clientSecret, String audience, String type) {
        this(null, issuer, issuerBackendUrl, clientId, clientSecret, audience, Type.valueOf(type), null);
    }

    public IdentityConfiguration(String baseUrl, String issuer, String issuerBackendUrl, String clientId, String clientSecret, String audience, String type) {
        this(baseUrl, issuer, issuerBackendUrl, clientId, clientSecret, audience, Type.valueOf(type), null);
    }

    public IdentityConfiguration(String baseUrl, String issuer, String issuerBackendUrl, String clientId, String clientSecret, String audience, String type, String authScopes) {
        this(baseUrl, issuer, issuerBackendUrl, clientId, clientSecret, audience, Type.valueOf(type), authScopes);
    }

    private IdentityConfiguration(String baseUrl, String issuer, String issuerBackendUrl, String clientId, String clientSecret, String audience, Type type, String authScopes) {
        Validate.notNull((Object)((Object)type), (String)"type must not be null", (Object[])new Object[0]);
        this.baseUrl = baseUrl;
        this.issuer = issuer;
        this.issuerBackendUrl = issuerBackendUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.audience = audience;
        this.type = type;
        this.authScopes = authScopes;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getIssuerBackendUrl() {
        return this.issuerBackendUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAudience() {
        return this.audience;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public Type getType() {
        return this.type;
    }

    public String getAuthScopes() {
        return this.authScopes;
    }

    public static enum Type {
        KEYCLOAK,
        AUTH0,
        MICROSOFT,
        GENERIC;

    }

    public static class Builder {
        private String issuer;
        private String issuerBackendUrl;
        private String clientId;
        private String clientSecret;
        private String audience;
        private String type = Type.KEYCLOAK.name();
        private String baseUrl = null;
        private String authScopes;

        public Builder() {
        }

        public Builder(String issuer, String issuerBackendUrl, String clientId, String clientSecret) {
            this.issuer = issuer;
            this.issuerBackendUrl = issuerBackendUrl;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.audience = clientId;
        }

        public Builder withIssuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder withIssuerBackendUrl(String issuerBackendUrl) {
            this.issuerBackendUrl = issuerBackendUrl;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder withBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder withAudience(String audience) {
            this.audience = audience;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withAuthScopes(String authScopes) {
            this.authScopes = authScopes;
            return this;
        }

        public IdentityConfiguration build() {
            return new IdentityConfiguration(this.baseUrl, this.issuer, this.issuerBackendUrl, this.clientId, this.clientSecret, this.audience, this.type, this.authScopes);
        }
    }
}

