/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.auth0.authentication;

import com.auth0.client.auth.AuthAPI;
import com.auth0.client.auth.AuthorizeUrlBuilder;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import java.net.URI;

class Auth0AuthorizeUriBuilder
extends AuthorizeUriBuilder {
    private static final String DEFAULT_SCOPES = "openid email";
    private final AuthAPI authApi;
    private final IdentityConfiguration configuration;
    private final String redirectUri;

    Auth0AuthorizeUriBuilder(IdentityConfiguration configuration, AuthAPI authApi, String redirectUri) {
        this.configuration = configuration;
        this.authApi = authApi;
        this.redirectUri = redirectUri;
    }

    @Override
    public URI build() {
        AuthorizeUrlBuilder builder = this.authApi.authorizeUrl(this.redirectUri).withScope(DEFAULT_SCOPES).withAudience(this.configuration.getAudience()).withState(this.state);
        return URI.create(builder.build());
    }
}

