/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.generic;

import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AbstractAuthentication;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.dto.AuthCodeDto;
import io.camunda.identity.sdk.authentication.exception.CodeExchangeException;
import io.camunda.identity.sdk.impl.dto.AccessTokenDto;
import io.camunda.identity.sdk.impl.dto.WellKnownConfiguration;
import io.camunda.identity.sdk.impl.generic.GenericAuthorizeUriBuilder;
import io.camunda.identity.sdk.impl.rest.RestClient;
import io.camunda.identity.sdk.impl.rest.request.ClientTokenRequest;
import io.camunda.identity.sdk.impl.rest.request.ExchangeAuthCodeRequest;
import io.camunda.identity.sdk.impl.rest.request.PermissionsRequest;
import io.camunda.identity.sdk.impl.rest.request.RenewTokenRequest;
import io.camunda.identity.sdk.impl.rest.request.RevokeTokenRequest;
import io.camunda.identity.sdk.impl.rest.request.WellKnownRequest;
import io.camunda.identity.sdk.utility.UrlUtility;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class GenericAuthentication
extends AbstractAuthentication {
    static final String PERMISSIONS_PATH = "/api/permissions";
    static final String FOR_TOKEN_PATH = "/for-token";
    protected JwkProvider jwkProvider;
    private WellKnownConfiguration wellKnownConfiguration;

    public GenericAuthentication(IdentityConfiguration configuration, RestClient restClient) {
        super(configuration, restClient);
    }

    @Override
    public AuthorizeUriBuilder authorizeUriBuilder(String redirectUri) {
        return new GenericAuthorizeUriBuilder(this.configuration, this.wellKnownConfiguration().getAuthorizationEndpoint(), redirectUri);
    }

    @Override
    public Tokens exchangeAuthCode(AuthCodeDto authCodeDto, String redirectUri) throws CodeExchangeException {
        Validate.notNull((Object)authCodeDto, (String)"authCodeDto must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)redirectUri, (String)"redirectUri must not be null", (Object[])new Object[0]);
        if (authCodeDto.getError() != null && !authCodeDto.getError().isBlank()) {
            throw new CodeExchangeException(authCodeDto.getError());
        }
        Validate.notEmpty((CharSequence)authCodeDto.getCode(), (String)"code must not be null", (Object[])new Object[0]);
        ExchangeAuthCodeRequest request = new ExchangeAuthCodeRequest(this.configuration, this.wellKnownConfiguration().getTokenEndpoint(), redirectUri, authCodeDto.getCode());
        AccessTokenDto accessTokenDto = this.restClient.request(request);
        return this.fromAccessTokenDto(accessTokenDto);
    }

    @Override
    protected Tokens requestFreshToken(String audience) {
        ClientTokenRequest request = new ClientTokenRequest(this.configuration, this.wellKnownConfiguration().getTokenEndpoint(), audience, null);
        AccessTokenDto accessTokenDto = this.restClient.request(request);
        return this.fromAccessTokenDto(accessTokenDto);
    }

    @Override
    public Tokens renewToken(String refreshToken) {
        Validate.notEmpty((CharSequence)refreshToken, (String)"refreshToken can not be empty", (Object[])new Object[0]);
        RenewTokenRequest request = new RenewTokenRequest(this.configuration, this.wellKnownConfiguration().getTokenEndpoint(), refreshToken);
        AccessTokenDto accessTokenDto = this.restClient.request(request);
        return this.fromAccessTokenDto(accessTokenDto);
    }

    @Override
    public void revokeToken(String refreshToken) {
        Validate.notEmpty((CharSequence)refreshToken, (String)"refreshToken can not be empty", (Object[])new Object[0]);
        if (this.isRevokeAvailable()) {
            throw new UnsupportedOperationException("revocation endpoint is not configured");
        }
        RevokeTokenRequest request = new RevokeTokenRequest(this.configuration, this.wellKnownConfiguration().getRevocationEndpoint(), refreshToken);
        this.restClient.request(request);
    }

    @Override
    public List<String> getPermissions(DecodedJWT token, String audience) {
        if (StringUtils.isNotBlank((CharSequence)audience)) {
            PermissionsRequest request = new PermissionsRequest(UrlUtility.combinePaths(this.configuration.getBaseUrl(), "/api/permissions/for-token"), token.getToken(), audience);
            return this.restClient.request(request);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isM2MToken(String token) {
        throw new NotImplementedException();
    }

    @Override
    public String getClientId(String token) {
        throw new NotImplementedException();
    }

    @Override
    public Map<String, Set<String>> getAssignedOrganizations(DecodedJWT token) {
        return Collections.emptyMap();
    }

    @Override
    protected JwkProvider jwkProvider() {
        if (this.jwkProvider == null) {
            try {
                this.jwkProvider = new JwkProviderBuilder(new URL(this.wellKnownConfiguration().getJwksUri())).cached(5L, 7L, TimeUnit.DAYS).build();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("invalid issuer url", e);
            }
        }
        return this.jwkProvider;
    }

    @Override
    protected WellKnownConfiguration wellKnownConfiguration() {
        if (this.wellKnownConfiguration == null) {
            WellKnownRequest wellKnownRequest = new WellKnownRequest(this.configuration);
            this.wellKnownConfiguration = this.restClient.request(wellKnownRequest);
        }
        return this.wellKnownConfiguration;
    }

    protected Tokens fromAccessTokenDto(AccessTokenDto dto) {
        return new Tokens(dto.getAccessToken(), dto.getRefreshToken(), dto.getExpiresIn(), dto.getScope(), dto.getTokenType());
    }

    @Override
    protected boolean isRevokeAvailable() {
        return this.wellKnownConfiguration().getRevocationEndpoint() != null;
    }

    @Override
    protected boolean isSingleSignOutAvailable() {
        return this.wellKnownConfiguration().getEndSessionEndpoint() != null;
    }
}

