/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl.microsoft;

import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.UserDetails;
import io.camunda.identity.sdk.impl.dto.AccessTokenDto;
import io.camunda.identity.sdk.impl.generic.GenericAuthentication;
import io.camunda.identity.sdk.impl.microsoft.MicrosoftAuthorizeUriBuilder;
import io.camunda.identity.sdk.impl.rest.RestClient;
import io.camunda.identity.sdk.impl.rest.request.ClientTokenRequest;
import io.camunda.identity.sdk.utility.UrlQueryString;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrosoftAuthentication
extends GenericAuthentication {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrosoftAuthentication.class);
    private static final String SIGN_OUT_CALLBACK_PARAM_NAME = "post_logout_redirect_uri";

    public MicrosoftAuthentication(IdentityConfiguration configuration, RestClient restClient) {
        super(configuration, restClient);
    }

    @Override
    public AuthorizeUriBuilder authorizeUriBuilder(String redirectUri) {
        return new MicrosoftAuthorizeUriBuilder(this.configuration, this.wellKnownConfiguration().getAuthorizationEndpoint(), redirectUri);
    }

    @Override
    public void revokeToken(String refreshToken) {
        LOGGER.info("Revoke token not required for Microsoft authentication. Skipping...");
    }

    @Override
    protected Tokens requestFreshToken(String audience) {
        ClientTokenRequest request = new ClientTokenRequest(this.configuration, this.wellKnownConfiguration().getTokenEndpoint(), audience, audience + "/.default");
        AccessTokenDto accessTokenDto = this.restClient.request(request);
        return this.fromAccessTokenDto(accessTokenDto);
    }

    @Override
    public boolean isM2MToken(String token) {
        DecodedJWT decodedJwt = this.decodeJWT(token);
        return decodedJwt.getClaim("email").isMissing();
    }

    @Override
    public String getClientId(String token) {
        DecodedJWT decodedJwt = this.decodeJWT(token);
        return decodedJwt.getClaim("appid").asString();
    }

    @Override
    protected UserDetails getUserDetails(DecodedJWT token, String organizationId) {
        return new UserDetails(token.getSubject(), token.getClaim("email").asString(), token.getClaim("unique_name").asString(), token.getClaim("name").asString(), this.getGroupsInOrganization(token, organizationId));
    }

    @Override
    protected URI generateSingleSignOutUri(String callbackUrl) {
        URI uri = super.generateSingleSignOutUri(callbackUrl);
        UrlQueryString query = new UrlQueryString().add(SIGN_OUT_CALLBACK_PARAM_NAME, callbackUrl);
        return URI.create(String.format("%s?%s", uri, query.toString()));
    }
}

