/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.utility;

import static io.camunda.identity.sdk.utility.UrlUtility.encodeQueryParameter;

import java.util.ArrayList;
import java.util.List;

public class UrlQueryString {
  private final List<String> queryParameters = new ArrayList<>();

  public UrlQueryString add(final String parameter, final String value) {
    queryParameters
      .add(String.format("%s=%s", encodeQueryParameter(parameter), encodeQueryParameter(value)));
    return this;
  }

  @Override
  public String toString() {
    return String.join("&", queryParameters);
  }
}
