/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.annotation;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.annotation.RequiresBaseUrl;
import io.camunda.identity.sdk.annotation.RequiresOAuthCredentials;
import io.camunda.identity.sdk.exception.InvalidConfigurationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.Validate;

public class AnnotationProcessor {
    public static <T> T apply(IdentityConfiguration configuration, Class<T> inf, T object) {
        return (T)Proxy.newProxyInstance(inf.getClassLoader(), new Class[]{inf}, (proxy, method, args) -> {
            try {
                if (method.isAnnotationPresent(RequiresOAuthCredentials.class)) {
                    AnnotationProcessor.validateOAuthCredentials(method, configuration);
                }
                if (method.isAnnotationPresent(RequiresBaseUrl.class)) {
                    AnnotationProcessor.validateBaseUrl(method, configuration);
                }
                return method.invoke(object, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        });
    }

    private static void validateOAuthCredentials(Method method, IdentityConfiguration configuration) {
        try {
            Validate.notBlank((CharSequence)configuration.getIssuer(), (String)"issuer must not be empty", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)configuration.getIssuerBackendUrl(), (String)"issuerBackendUrl must not be empty", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)configuration.getClientId(), (String)"clientId must not be empty", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)configuration.getClientSecret(), (String)"clientSecret must not be empty", (Object[])new Object[0]);
        }
        catch (Throwable throwable) {
            throw new InvalidConfigurationException(String.format("'%s' can only be used if OAuth credentials are provided", method.getName()), throwable);
        }
    }

    private static void validateBaseUrl(Method method, IdentityConfiguration configuration) {
        try {
            Validate.notBlank((CharSequence)configuration.getBaseUrl(), (String)"baseUrl must not be empty", (Object[])new Object[0]);
        }
        catch (Throwable throwable) {
            throw new InvalidConfigurationException(String.format("'%s' can only be used if baseUrl is provided", method.getName()), throwable);
        }
    }
}

