/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.autoconfigure;

import io.camunda.identity.sdk.IdentityConfiguration.Type;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "camunda.identity")
public record IdentityProperties(
    String baseUrl,
    String issuer,
    String issuerBackendUrl,
    String clientId,
    String clientSecret,
    String audience,
    Type type,
    String authScopes
) {
  @Override
  public Type type() {
    return type == null ? Type.KEYCLOAK : type;
  }
}
