/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.connector;

import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.util.outbound.OutboundConnectorRegistrationHelper;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.connector.OutboundConnectorConfigurationComparator;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundConnectorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Set<OutboundConnectorConfiguration> outboundConnectors = new TreeSet<OutboundConnectorConfiguration>(new OutboundConnectorConfigurationComparator());
    private final JobWorkerManager jobWorkerManager;

    public OutboundConnectorManager(JobWorkerManager jobWorkerManager) {
        this.jobWorkerManager = jobWorkerManager;
    }

    public void addConnectorDefinition(OutboundConnectorConfiguration connector) {
        if (this.outboundConnectors.contains(connector)) {
            LOGGER.info("Duplicate configuration of outbound connector {}. Ignoring.", (Object)connector);
        } else {
            this.outboundConnectors.add(connector);
        }
    }

    public void start(ZeebeClient client) {
        this.loadClasspathOutboundConnectors();
        this.outboundConnectors.forEach(connector -> this.openWorkerForOutboundConnector(client, (OutboundConnectorConfiguration)connector));
    }

    public void loadClasspathOutboundConnectors() {
        LOGGER.info("Reading environment variables or parsing SPI to find connectors that are not Spring beans");
        List outboundConnectors = OutboundConnectorRegistrationHelper.parse();
        if (outboundConnectors.isEmpty()) {
            LOGGER.warn("No outbound connectors configured or found in classpath");
        } else {
            LOGGER.info("Found outbound connectors via classpath that will be registered: " + outboundConnectors);
        }
        for (OutboundConnectorConfiguration connector : outboundConnectors) {
            this.addConnectorDefinition(connector);
        }
    }

    public void openWorkerForOutboundConnector(ZeebeClient client, OutboundConnectorConfiguration connector) {
        ZeebeWorkerValue zeebeWorkerValue = new ZeebeWorkerValue().setName(connector.getName()).setType(connector.getType()).setFetchVariables(connector.getInputVariables()).setAutoComplete(true);
        this.jobWorkerManager.openWorker(client, zeebeWorkerValue, connector);
    }

    public void stop(ZeebeClient client) {
        this.jobWorkerManager.closeAllOpenWorkers();
    }
}

