/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.auth;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SimpleAuthenticationBuilder;
import io.camunda.common.auth.SimpleConfig;
import io.camunda.common.auth.SimpleCredential;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthentication
implements Authentication {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SimpleConfig simpleConfig;
    private final Map<Product, Map<String, String>> tokens = new HashMap<Product, Map<String, String>>();

    public SimpleAuthentication(SimpleConfig simpleConfig) {
        this.simpleConfig = simpleConfig;
    }

    public static SimpleAuthenticationBuilder builder() {
        return new SimpleAuthenticationBuilder();
    }

    public SimpleConfig getSimpleConfig() {
        return this.simpleConfig;
    }

    private Map<String, String> retrieveToken(Product product, SimpleCredential simpleCredential) {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost request = this.buildRequest(simpleCredential);
            Map headers = ((List)client.execute((ClassicHttpRequest)request, response -> List.of(response.getHeaders()))).stream().reduce(new HashMap(), (map, header) -> this.insertHeader((HashMap<String, String>)map, (Header)header, product), (pMap, cMap) -> {
                pMap.putAll(cMap);
                return pMap;
            });
            if (headers.get("Cookie") == null) {
                throw new RuntimeException("Unable to authenticate due to missing Set-Cookie");
            }
            this.tokens.put(product, headers);
        }
        catch (Exception e) {
            LOG.error("Authenticating for " + String.valueOf((Object)product) + " failed due to " + String.valueOf(e));
            throw new RuntimeException("Unable to authenticate", e);
        }
        return this.tokens.get((Object)product);
    }

    private HashMap<String, String> insertHeader(HashMap<String, String> map, Header header, Product product) {
        if (header.getValue().startsWith(product.toString().toUpperCase())) {
            map.merge("Cookie", header.getValue(), (s, s2) -> s.concat("; ".concat((String)s2)));
        } else if (header.getName().equals(product.toString().toUpperCase() + "-X-CSRF-TOKEN")) {
            map.put(header.getName(), header.getValue());
        }
        return map;
    }

    private HttpPost buildRequest(SimpleCredential simpleCredential) {
        HttpPost httpPost = new HttpPost(simpleCredential.getBaseUrl() + "/api/login");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("username", simpleCredential.getUser()));
        params.add(new BasicNameValuePair("password", simpleCredential.getPassword()));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return httpPost;
    }

    @Override
    public Map<String, String> getTokenHeader(Product product) {
        if (this.tokens.containsKey((Object)product)) {
            return this.tokens.get((Object)product);
        }
        SimpleCredential simpleCredential = this.simpleConfig.getProduct(product);
        return this.retrieveToken(product, simpleCredential);
    }

    @Override
    public void resetToken(Product product) {
        this.tokens.remove((Object)product);
    }
}

