/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.DefaultNoopAuthentication;
import io.camunda.common.auth.Product;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.zeebe.client.impl.util.Environment;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.properties.CommonConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.StringUtils;

public class ZeebeClientConfiguration
implements io.camunda.zeebe.client.ZeebeClientConfiguration {
    @Autowired
    private ZeebeClientConfigurationProperties properties;
    @Autowired
    private CommonConfigurationProperties commonConfigurationProperties;
    @Autowired
    private Authentication authentication;
    @Lazy
    @Autowired
    private JsonMapper jsonMapper;
    @Lazy
    @Autowired(required=false)
    private List<ClientInterceptor> interceptors;
    @Lazy
    @Autowired
    private ZeebeClientExecutorService zeebeClientExecutorService;

    @PostConstruct
    public void applyLegacy() {
        this.properties.applyOverrides();
    }

    public String getGatewayAddress() {
        return this.properties.getGatewayAddress();
    }

    public String getDefaultTenantId() {
        return this.properties.getDefaultTenantId();
    }

    public List<String> getDefaultJobWorkerTenantIds() {
        return this.properties.getDefaultJobWorkerTenantIds();
    }

    public int getNumJobWorkerExecutionThreads() {
        return this.properties.getNumJobWorkerExecutionThreads();
    }

    public int getDefaultJobWorkerMaxJobsActive() {
        return this.properties.getDefaultJobWorkerMaxJobsActive();
    }

    public String getDefaultJobWorkerName() {
        return this.properties.getDefaultJobWorkerName();
    }

    public Duration getDefaultJobTimeout() {
        return this.properties.getDefaultJobTimeout();
    }

    public Duration getDefaultJobPollInterval() {
        return this.properties.getDefaultJobPollInterval();
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.properties.getDefaultMessageTimeToLive();
    }

    public Duration getDefaultRequestTimeout() {
        return this.properties.getDefaultRequestTimeout();
    }

    public boolean isPlaintextConnectionEnabled() {
        return this.properties.isPlaintextConnectionEnabled();
    }

    public String getCaCertificatePath() {
        return this.properties.getCaCertificatePath();
    }

    public CredentialsProvider getCredentialsProvider() {
        if (this.commonConfigurationProperties.getEnabled().booleanValue() && !(this.authentication instanceof DefaultNoopAuthentication)) {
            return new CredentialsProvider(){

                public void applyCredentials(Metadata headers) {
                    Map.Entry authHeader = ZeebeClientConfiguration.this.authentication.getTokenHeader(Product.ZEEBE);
                    Metadata.Key authHeaderKey = Metadata.Key.of((String)((String)authHeader.getKey()), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                    headers.put(authHeaderKey, (Object)((String)authHeader.getValue()));
                }

                public boolean shouldRetryRequest(Throwable throwable) {
                    return ((StatusRuntimeException)throwable).getStatus() == Status.DEADLINE_EXCEEDED;
                }
            };
        }
        if (StringUtils.hasText((String)this.properties.getCloud().getClientId()) && StringUtils.hasText((String)this.properties.getCloud().getClientSecret())) {
            return CredentialsProvider.newCredentialsProviderBuilder().clientId(this.properties.getCloud().getClientId()).clientSecret(this.properties.getCloud().getClientSecret()).audience(this.properties.getCloud().getAudience()).scope(this.properties.getCloud().getScope()).authorizationServerUrl(this.properties.getCloud().getAuthUrl()).credentialsCachePath(this.properties.getCloud().getCredentialsCachePath()).build();
        }
        if (Environment.system().get("ZEEBE_CLIENT_ID") != null && Environment.system().get("ZEEBE_CLIENT_SECRET") != null) {
            OAuthCredentialsProviderBuilder builder = CredentialsProvider.newCredentialsProviderBuilder();
            int separatorIndex = this.properties.getBroker().getGatewayAddress().lastIndexOf(58);
            if (separatorIndex > 0) {
                builder.audience(this.properties.getBroker().getGatewayAddress().substring(0, separatorIndex));
            }
            return builder.build();
        }
        return null;
    }

    public Duration getKeepAlive() {
        return this.properties.getKeepAlive();
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public String getOverrideAuthority() {
        return this.properties.getOverrideAuthority();
    }

    public int getMaxMessageSize() {
        return this.properties.getMaxMessageSize();
    }

    public ScheduledExecutorService jobWorkerExecutor() {
        return this.zeebeClientExecutorService.get();
    }

    public boolean ownsJobWorkerExecutor() {
        return this.properties.ownsJobWorkerExecutor();
    }

    public boolean getDefaultJobWorkerStreamEnabled() {
        return this.properties.getDefaultJobWorkerStreamEnabled();
    }

    public boolean useDefaultRetryPolicy() {
        return this.properties.useDefaultRetryPolicy();
    }
}

