/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtil.class);

    public static <T> T getOrLegacyOrDefault(String propertyName, Supplier<T> propertySupplier, Supplier<T> legacyPropertySupplier, T defaultProperty, Map<String, Object> configCache) {
        T property = defaultProperty;
        if (configCache != null) {
            try {
                LOG.debug("Property {}: Loading from cache", (Object)propertyName);
                if (configCache.containsKey(propertyName)) {
                    return (T)configCache.get(propertyName);
                }
            }
            catch (Exception e) {
                LOG.debug("Error while loading cached property " + propertyName, (Throwable)e);
            }
        }
        if (property == null || property.equals(defaultProperty)) {
            LOG.debug("Propery {}: not set or default, applying legacy property", (Object)propertyName);
            try {
                property = legacyPropertySupplier.get();
            }
            catch (Exception e) {
                LOG.debug("Error while loading legacy property " + propertyName, (Throwable)e);
            }
        }
        if (property == null || property.equals(defaultProperty)) {
            LOG.debug("Propery {}: not set or default, applying property", (Object)propertyName);
            try {
                property = propertySupplier.get();
            }
            catch (Exception e) {
                LOG.debug("Error while loading property " + propertyName, (Throwable)e);
            }
        }
        if (property == null || property.equals(defaultProperty)) {
            LOG.debug("Propery {}: not set or default, using default", (Object)propertyName);
            property = defaultProperty;
        }
        if (configCache != null) {
            configCache.put(propertyName, property);
        }
        return property;
    }

    public static <T> Supplier<T> prioritized(T defaultProperty, List<Supplier<T>> suppliers) {
        for (Supplier<T> supplier : suppliers) {
            try {
                T property = supplier.get();
                if (property == null || property.equals(defaultProperty)) continue;
                return supplier;
            }
            catch (Exception exception) {
            }
        }
        return () -> defaultProperty;
    }
}

