/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling.parameter;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.spring.client.jobhandling.parameter.ParameterResolver;

public class VariableResolver
implements ParameterResolver {
    private final String variableName;
    private final Class<?> variableType;
    private final JsonMapper jsonMapper;

    public VariableResolver(String variableName, Class<?> variableType, JsonMapper jsonMapper) {
        this.variableName = variableName;
        this.variableType = variableType;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public Object resolve(JobClient jobClient, ActivatedJob job) {
        Object variableValue = this.getVariable(job);
        try {
            return this.mapZeebeVariable(variableValue);
        }
        catch (ClassCastException | IllegalArgumentException ex) {
            throw new RuntimeException("Cannot assign process variable '" + this.variableName + "' to parameter when executing job '" + job.getType() + "', invalid type found: " + ex.getMessage());
        }
    }

    protected Object getVariable(ActivatedJob job) {
        return job.getVariable(this.variableName);
    }

    protected Object mapZeebeVariable(Object variableValue) {
        if (variableValue != null && !this.variableType.isInstance(variableValue)) {
            return this.jsonMapper.fromJson(this.jsonMapper.toJson(variableValue), this.variableType);
        }
        return this.variableType.cast(variableValue);
    }
}

