/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public final class ExtensionElementsValidator<T extends BaseElement, E extends ModelElementInstance>
implements ModelElementValidator<T> {
    private final Class<T> elementType;
    private final Class<E> extensionElement;
    private final String extensionElementName;

    private ExtensionElementsValidator(Class<T> elementType, Class<E> extensionElement, String extensionElementName) {
        this.elementType = elementType;
        this.extensionElement = extensionElement;
        this.extensionElementName = extensionElementName;
    }

    public Class<T> getElementType() {
        return this.elementType;
    }

    public void validate(T element, ValidationResultCollector validationResultCollector) {
        ExtensionElements extensionElements = element.getExtensionElements();
        if (extensionElements == null || extensionElements.getChildElementsByType(this.extensionElement).size() != 1) {
            validationResultCollector.addError(0, String.format("Must have exactly one 'zeebe:%s' extension element", this.extensionElementName));
        }
    }

    public static <T extends BaseElement> Builder<T> verifyThat(Class<T> elementType) {
        return new Builder<T>(elementType);
    }

    public static class Builder<T extends BaseElement> {
        private final Class<T> elementType;

        public Builder(Class<T> elementType) {
            this.elementType = elementType;
        }

        public <E extends ModelElementInstance> ExtensionElementsValidator<T, E> hasSingleExtensionElement(Class<E> extensionElement, String name) {
            return new ExtensionElementsValidator(this.elementType, extensionElement, name);
        }
    }
}

