/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.response.Decision;
import io.camunda.zeebe.client.api.response.DecisionRequirements;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.client.impl.Loggers;
import io.camunda.zeebe.client.impl.response.DecisionImpl;
import io.camunda.zeebe.client.impl.response.DecisionRequirementsImpl;
import io.camunda.zeebe.client.impl.response.ProcessImpl;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class DeploymentEventImpl
implements DeploymentEvent {
    private static final Logger LOG = Loggers.LOGGER;
    private static final String UNKNOWN_METADATA_WARN_MSG = "Expected metadata in deployment response, but encountered an unknown type of metadata. This might happen when you've updated your Zeebe cluster, but not your Zeebe client. You may have to update the version of your zeebe-client-java dependency to resolve the issue.";
    private final long key;
    private final List<Process> processes = new ArrayList<Process>();
    private final List<Decision> decisions = new ArrayList<Decision>();
    private final List<DecisionRequirements> decisionRequirements = new ArrayList<DecisionRequirements>();

    public DeploymentEventImpl(GatewayOuterClass.DeployProcessResponse response) {
        this.key = response.getKey();
        response.getProcessesList().stream().map(ProcessImpl::new).forEach(this.processes::add);
    }

    public DeploymentEventImpl(GatewayOuterClass.DeployResourceResponse response) {
        this.key = response.getKey();
        block5: for (GatewayOuterClass.Deployment deployment : response.getDeploymentsList()) {
            switch (deployment.getMetadataCase()) {
                case PROCESS: {
                    this.processes.add(new ProcessImpl(deployment.getProcess()));
                    continue block5;
                }
                case DECISION: {
                    this.decisions.add(new DecisionImpl(deployment.getDecision()));
                    continue block5;
                }
                case DECISIONREQUIREMENTS: {
                    this.decisionRequirements.add(new DecisionRequirementsImpl(deployment.getDecisionRequirements()));
                    continue block5;
                }
            }
            LOG.warn(UNKNOWN_METADATA_WARN_MSG);
        }
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public List<Process> getProcesses() {
        return this.processes;
    }

    @Override
    public List<Decision> getDecisions() {
        return this.decisions;
    }

    @Override
    public List<DecisionRequirements> getDecisionRequirements() {
        return this.decisionRequirements;
    }

    public String toString() {
        return "DeploymentEventImpl{key=" + this.key + ", processes=" + this.processes + ", decisions=" + this.decisions + ", decisionRequirements=" + this.decisionRequirements + '}';
    }
}

