/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.worker;

import io.camunda.zeebe.client.api.response.ActivatedJob;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
interface JobStreamer
extends AutoCloseable {
    @Override
    public void close();

    public boolean isOpen();

    public void openStreamer(Consumer<ActivatedJob> var1);

    public static JobStreamer noop() {
        return NoopJobStream.Singleton.INSTANCE.stream;
    }

    @ThreadSafe
    public static final class NoopJobStream
    implements JobStreamer {
        @Override
        public void close() {
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void openStreamer(Consumer<ActivatedJob> jobConsumer) {
        }

        private static enum Singleton {
            INSTANCE(new NoopJobStream());

            private final NoopJobStream stream;

            private Singleton(NoopJobStream stream) {
                this.stream = stream;
            }
        }
    }
}

