/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.impl.GrpcStatusCode;
import io.camunda.zeebe.client.impl.ZeebeStreamingClientFutureImpl;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class RetriableStreamingFutureImpl<C, B>
extends ZeebeStreamingClientFutureImpl<C, B> {
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final Consumer<StreamObserver<B>> retryAction;

    public RetriableStreamingFutureImpl(C clientResponse, Consumer<B> collector, Predicate<CredentialsProvider.StatusCode> retryPredicate, Consumer<StreamObserver<B>> retryAction) {
        super(clientResponse, collector);
        Objects.requireNonNull(retryPredicate, "Expected to have non-null retry predicate.");
        Objects.requireNonNull(retryAction, "Expected to have non-null retry action.");
        this.retryPredicate = retryPredicate;
        this.retryAction = retryAction;
    }

    @Override
    public void onError(Throwable throwable) {
        Status status = Status.fromThrowable((Throwable)throwable);
        if (status.getCode() != Status.Code.UNKNOWN && this.retryPredicate.test(new GrpcStatusCode(status.getCode()))) {
            this.retryAction.accept((StreamObserver<B>)this);
        } else {
            super.onError(throwable);
        }
    }
}

