/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.DeploymentDecision;
import io.camunda.zeebe.client.protocol.rest.DeploymentDecisionRequirements;
import io.camunda.zeebe.client.protocol.rest.DeploymentForm;
import io.camunda.zeebe.client.protocol.rest.DeploymentProcess;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"processDefinition", "decisionDefinition", "decisionRequirements", "form"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeploymentMetadata {
    public static final String JSON_PROPERTY_PROCESS_DEFINITION = "processDefinition";
    private DeploymentProcess processDefinition;
    public static final String JSON_PROPERTY_DECISION_DEFINITION = "decisionDefinition";
    private DeploymentDecision decisionDefinition;
    public static final String JSON_PROPERTY_DECISION_REQUIREMENTS = "decisionRequirements";
    private DeploymentDecisionRequirements decisionRequirements;
    public static final String JSON_PROPERTY_FORM = "form";
    private DeploymentForm form;

    public DeploymentMetadata processDefinition(DeploymentProcess processDefinition) {
        this.processDefinition = processDefinition;
        return this;
    }

    @Nullable
    @JsonProperty(value="processDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeploymentProcess getProcessDefinition() {
        return this.processDefinition;
    }

    @JsonProperty(value="processDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessDefinition(DeploymentProcess processDefinition) {
        this.processDefinition = processDefinition;
    }

    public DeploymentMetadata decisionDefinition(DeploymentDecision decisionDefinition) {
        this.decisionDefinition = decisionDefinition;
        return this;
    }

    @Nullable
    @JsonProperty(value="decisionDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeploymentDecision getDecisionDefinition() {
        return this.decisionDefinition;
    }

    @JsonProperty(value="decisionDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecisionDefinition(DeploymentDecision decisionDefinition) {
        this.decisionDefinition = decisionDefinition;
    }

    public DeploymentMetadata decisionRequirements(DeploymentDecisionRequirements decisionRequirements) {
        this.decisionRequirements = decisionRequirements;
        return this;
    }

    @Nullable
    @JsonProperty(value="decisionRequirements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeploymentDecisionRequirements getDecisionRequirements() {
        return this.decisionRequirements;
    }

    @JsonProperty(value="decisionRequirements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDecisionRequirements(DeploymentDecisionRequirements decisionRequirements) {
        this.decisionRequirements = decisionRequirements;
    }

    public DeploymentMetadata form(DeploymentForm form) {
        this.form = form;
        return this;
    }

    @Nullable
    @JsonProperty(value="form")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeploymentForm getForm() {
        return this.form;
    }

    @JsonProperty(value="form")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setForm(DeploymentForm form) {
        this.form = form;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentMetadata deploymentMetadata = (DeploymentMetadata)o;
        return Objects.equals(this.processDefinition, deploymentMetadata.processDefinition) && Objects.equals(this.decisionDefinition, deploymentMetadata.decisionDefinition) && Objects.equals(this.decisionRequirements, deploymentMetadata.decisionRequirements) && Objects.equals(this.form, deploymentMetadata.form);
    }

    public int hashCode() {
        return Objects.hash(this.processDefinition, this.decisionDefinition, this.decisionRequirements, this.form);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeploymentMetadata {\n");
        sb.append("    processDefinition: ").append(this.toIndentedString(this.processDefinition)).append("\n");
        sb.append("    decisionDefinition: ").append(this.toIndentedString(this.decisionDefinition)).append("\n");
        sb.append("    decisionRequirements: ").append(this.toIndentedString(this.decisionRequirements)).append("\n");
        sb.append("    form: ").append(this.toIndentedString(this.form)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getProcessDefinition() != null) {
            joiner.add(this.getProcessDefinition().toUrlQueryString(prefix + JSON_PROPERTY_PROCESS_DEFINITION + suffix));
        }
        if (this.getDecisionDefinition() != null) {
            joiner.add(this.getDecisionDefinition().toUrlQueryString(prefix + JSON_PROPERTY_DECISION_DEFINITION + suffix));
        }
        if (this.getDecisionRequirements() != null) {
            joiner.add(this.getDecisionRequirements().toUrlQueryString(prefix + JSON_PROPERTY_DECISION_REQUIREMENTS + suffix));
        }
        if (this.getForm() != null) {
            joiner.add(this.getForm().toUrlQueryString(prefix + JSON_PROPERTY_FORM + suffix));
        }
        return joiner.toString();
    }
}

