/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "worker", "timeout", "maxJobsToActivate", "fetchVariable", "requestTimeout", "tenantIds"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobActivationRequest {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_WORKER = "worker";
    private String worker;
    public static final String JSON_PROPERTY_TIMEOUT = "timeout";
    private Long timeout;
    public static final String JSON_PROPERTY_MAX_JOBS_TO_ACTIVATE = "maxJobsToActivate";
    private Integer maxJobsToActivate;
    public static final String JSON_PROPERTY_FETCH_VARIABLE = "fetchVariable";
    private List<String> fetchVariable;
    public static final String JSON_PROPERTY_REQUEST_TIMEOUT = "requestTimeout";
    private Long requestTimeout = 0L;
    public static final String JSON_PROPERTY_TENANT_IDS = "tenantIds";
    private List<String> tenantIds;

    public JobActivationRequest type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public JobActivationRequest worker(String worker) {
        this.worker = worker;
        return this;
    }

    @Nullable
    @JsonProperty(value="worker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorker() {
        return this.worker;
    }

    @JsonProperty(value="worker")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorker(String worker) {
        this.worker = worker;
    }

    public JobActivationRequest timeout(Long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public JobActivationRequest maxJobsToActivate(Integer maxJobsToActivate) {
        this.maxJobsToActivate = maxJobsToActivate;
        return this;
    }

    @Nonnull
    @JsonProperty(value="maxJobsToActivate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getMaxJobsToActivate() {
        return this.maxJobsToActivate;
    }

    @JsonProperty(value="maxJobsToActivate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxJobsToActivate(Integer maxJobsToActivate) {
        this.maxJobsToActivate = maxJobsToActivate;
    }

    public JobActivationRequest fetchVariable(List<String> fetchVariable) {
        this.fetchVariable = fetchVariable;
        return this;
    }

    public JobActivationRequest addFetchVariableItem(String fetchVariableItem) {
        if (this.fetchVariable == null) {
            this.fetchVariable = new ArrayList<String>();
        }
        this.fetchVariable.add(fetchVariableItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="fetchVariable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFetchVariable() {
        return this.fetchVariable;
    }

    @JsonProperty(value="fetchVariable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFetchVariable(List<String> fetchVariable) {
        this.fetchVariable = fetchVariable;
    }

    public JobActivationRequest requestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Nullable
    @JsonProperty(value="requestTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    @JsonProperty(value="requestTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public JobActivationRequest tenantIds(List<String> tenantIds) {
        this.tenantIds = tenantIds;
        return this;
    }

    public JobActivationRequest addTenantIdsItem(String tenantIdsItem) {
        if (this.tenantIds == null) {
            this.tenantIds = new ArrayList<String>();
        }
        this.tenantIds.add(tenantIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tenantIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTenantIds() {
        return this.tenantIds;
    }

    @JsonProperty(value="tenantIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantIds(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobActivationRequest jobActivationRequest = (JobActivationRequest)o;
        return Objects.equals(this.type, jobActivationRequest.type) && Objects.equals(this.worker, jobActivationRequest.worker) && Objects.equals(this.timeout, jobActivationRequest.timeout) && Objects.equals(this.maxJobsToActivate, jobActivationRequest.maxJobsToActivate) && Objects.equals(this.fetchVariable, jobActivationRequest.fetchVariable) && Objects.equals(this.requestTimeout, jobActivationRequest.requestTimeout) && Objects.equals(this.tenantIds, jobActivationRequest.tenantIds);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.worker, this.timeout, this.maxJobsToActivate, this.fetchVariable, this.requestTimeout, this.tenantIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobActivationRequest {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    worker: ").append(this.toIndentedString(this.worker)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    maxJobsToActivate: ").append(this.toIndentedString(this.maxJobsToActivate)).append("\n");
        sb.append("    fetchVariable: ").append(this.toIndentedString(this.fetchVariable)).append("\n");
        sb.append("    requestTimeout: ").append(this.toIndentedString(this.requestTimeout)).append("\n");
        sb.append("    tenantIds: ").append(this.toIndentedString(this.tenantIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getWorker() != null) {
            try {
                joiner.add(String.format("%sworker%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getWorker()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTimeout() != null) {
            try {
                joiner.add(String.format("%stimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTimeout()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getMaxJobsToActivate() != null) {
            try {
                joiner.add(String.format("%smaxJobsToActivate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMaxJobsToActivate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFetchVariable() != null) {
            for (i = 0; i < this.getFetchVariable().size(); ++i) {
                try {
                    joiner.add(String.format("%sfetchVariable%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getFetchVariable().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getRequestTimeout() != null) {
            try {
                joiner.add(String.format("%srequestTimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRequestTimeout()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTenantIds() != null) {
            for (i = 0; i < this.getTenantIds().size(); ++i) {
                try {
                    joiner.add(String.format("%stenantIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getTenantIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

