/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "correlationKey", "variables", "tenantId"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessageCorrelationRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CORRELATION_KEY = "correlationKey";
    private String correlationKey = "";
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private Map<String, Object> variables;
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    private String tenantId;

    public MessageCorrelationRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public MessageCorrelationRequest correlationKey(String correlationKey) {
        this.correlationKey = correlationKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="correlationKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCorrelationKey() {
        return this.correlationKey;
    }

    @JsonProperty(value="correlationKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public MessageCorrelationRequest variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public MessageCorrelationRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="variables")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public MessageCorrelationRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageCorrelationRequest messageCorrelationRequest = (MessageCorrelationRequest)o;
        return Objects.equals(this.name, messageCorrelationRequest.name) && Objects.equals(this.correlationKey, messageCorrelationRequest.correlationKey) && Objects.equals(this.variables, messageCorrelationRequest.variables) && Objects.equals(this.tenantId, messageCorrelationRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.correlationKey, this.variables, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageCorrelationRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    correlationKey: ").append(this.toIndentedString(this.correlationKey)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCorrelationKey() != null) {
            try {
                joiner.add(String.format("%scorrelationKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCorrelationKey()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVariables() != null) {
            for (String _key : this.getVariables().keySet()) {
                try {
                    joiner.add(String.format("%svariables%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getVariables().get(_key), URLEncoder.encode(String.valueOf(this.getVariables().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getTenantId() != null) {
            try {
                joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

