/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl;

import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class DbBytes
implements DbKey,
DbValue {
    private final DirectBuffer bytes = new UnsafeBuffer(0L, 0);

    public void wrapBytes(byte[] value) {
        this.bytes.wrap(value);
    }

    public void wrap(DirectBuffer directBuffer, int offset, int length) {
        byte[] bytesToWrap = new byte[length];
        directBuffer.getBytes(offset, bytesToWrap, 0, bytesToWrap.length);
        this.bytes.wrap(bytesToWrap);
    }

    public int getLength() {
        return this.bytes.capacity();
    }

    public void write(MutableDirectBuffer mutableDirectBuffer, int offset) {
        mutableDirectBuffer.putBytes(offset, this.bytes, 0, this.bytes.capacity());
    }

    public byte[] getBytes() {
        return this.bytes.byteArray();
    }

    public String toString() {
        return "DbByte{bytes=" + BufferUtil.bufferAsString((DirectBuffer)this.bytes) + "}";
    }

    public DirectBuffer getDirectBuffer() {
        return this.bytes;
    }
}

