/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.feel.impl;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.camunda.feel.context.JavaFunction;
import org.camunda.feel.context.JavaFunctionProvider;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValDayTimeDuration;
import org.camunda.feel.syntaxtree.ValError;
import org.camunda.feel.syntaxtree.ValNull$;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValString;
import org.camunda.feel.syntaxtree.ValYearMonthDuration;

public class FeelFunctionProvider
extends JavaFunctionProvider {
    private static final Map<String, List<JavaFunction>> FUNCTIONS = Map.of("cycle", List.of(CycleFunction.INSTANCE, CycleInfiniteFunction.INSTANCE));

    public Optional<JavaFunction> resolveFunction(String functionName) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getFunctionNames() {
        return FUNCTIONS.keySet();
    }

    public List<JavaFunction> resolveFunctions(String functionName) {
        return FUNCTIONS.getOrDefault(functionName, List.of());
    }

    private static final class CycleFunction
    extends JavaFunction {
        public static final CycleFunction INSTANCE = new CycleFunction();

        public CycleFunction() {
            super(List.of("repetitions", "interval"), CycleFunction::invoke);
        }

        private static Val invoke(List<Val> args) {
            if (args.size() != 2) {
                new ValError("cycle function expected exactly two parameters, but found %s: '%s'".formatted(args.size(), args));
            }
            Val val = args.get(0);
            Objects.requireNonNull(val);
            Val val2 = val;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ValNull$.class, ValNumber.class}, (Object)val2, n)) {
                case 0 -> {
                    ValNull$ ignored = (ValNull$)val2;
                    Val v1 = args.get(1);
                    Objects.requireNonNull(v1);
                    Val var6_4 = v1;
                    int var7_6 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ValDayTimeDuration.class, ValYearMonthDuration.class}, (Object)var6_4, var7_6)) {
                        case 0: {
                            ValDayTimeDuration duration = (ValDayTimeDuration)var6_4;
                            yield new ValString("R/%s".formatted(duration));
                        }
                        case 1: {
                            ValYearMonthDuration duration = (ValYearMonthDuration)var6_4;
                            yield new ValString("R/%s".formatted(duration));
                        }
                    }
                    yield new ValError("cycle function expected a repetitions (number) and an interval (duration) parameter, but found '%s'".formatted(args));
                }
                case 1 -> {
                    ValNumber repetitions = (ValNumber)val2;
                    Val v3 = args.get(1);
                    Objects.requireNonNull(v3);
                    Val var9_10 = v3;
                    int var10_11 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ValDayTimeDuration.class, ValYearMonthDuration.class}, (Object)var9_10, var10_11)) {
                        case 0: {
                            ValDayTimeDuration duration = (ValDayTimeDuration)var9_10;
                            yield new ValString("R%d/%S".formatted(repetitions.value().intValue(), duration));
                        }
                        case 1: {
                            ValYearMonthDuration duration = (ValYearMonthDuration)var9_10;
                            yield new ValString("R%d/%S".formatted(repetitions.value().intValue(), duration));
                        }
                    }
                    yield new ValError("cycle function expected a repetitions (number) and an interval (duration) parameter, but found '%s'".formatted(args));
                }
                default -> new ValError("cycle function expected a repetitions (number) and an interval (duration) parameter, but found '%s'".formatted(args));
            };
        }
    }

    private static final class CycleInfiniteFunction
    extends JavaFunction {
        public static final CycleInfiniteFunction INSTANCE = new CycleInfiniteFunction();

        public CycleInfiniteFunction() {
            super(List.of("repetitions"), CycleInfiniteFunction::invoke);
        }

        private static Val invoke(List<Val> args) {
            if (args.size() != 1) {
                new ValError("cycle function expected exactly one interval (duration) parameter, but found %s: '%s'".formatted(args.size(), args));
            }
            Val val = args.getFirst();
            Objects.requireNonNull(val);
            Val val2 = val;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ValDayTimeDuration.class, ValYearMonthDuration.class, ValError.class}, (Object)val2, n)) {
                case 0 -> {
                    ValDayTimeDuration duration = (ValDayTimeDuration)val2;
                    yield new ValString("R/%s".formatted(duration));
                }
                case 1 -> {
                    ValYearMonthDuration duration = (ValYearMonthDuration)val2;
                    yield new ValString("R/%s".formatted(duration));
                }
                case 2 -> {
                    ValError e;
                    yield e = (ValError)val2;
                }
                default -> new ValError("cycle function expected an interval (duration) parameter, but found '%s'".formatted(args.getFirst()));
            };
        }
    }
}

