/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.WindowedLimit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.AppendErrorHandler;
import io.camunda.zeebe.logstreams.impl.flowcontrol.AppendLimiter;
import io.camunda.zeebe.logstreams.impl.flowcontrol.AppenderMetrics;
import io.camunda.zeebe.logstreams.impl.flowcontrol.BackpressureCfg;
import io.camunda.zeebe.logstreams.impl.flowcontrol.BackpressureCfgGradient2;
import io.camunda.zeebe.logstreams.impl.flowcontrol.BackpressureCfgVegas;
import io.camunda.zeebe.logstreams.impl.flowcontrol.InFlightAppend;
import io.camunda.zeebe.logstreams.impl.flowcontrol.NoopLimiter;
import io.camunda.zeebe.util.Environment;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppenderFlowControl {
    private static final Logger LOG = LoggerFactory.getLogger(AppenderFlowControl.class);
    private static final Map<String, BackpressureCfg> ALGORITHM_CFG = Map.of("vegas", new BackpressureCfgVegas(), "gradient2", new BackpressureCfgGradient2());
    private final AppendErrorHandler errorHandler;
    private final Limiter<Void> limiter;
    private final AppenderMetrics metrics;

    public AppenderFlowControl(AppendErrorHandler errorHandler, int partitionId) {
        this.errorHandler = errorHandler;
        this.metrics = new AppenderMetrics(partitionId);
        this.limiter = this.configureLimiter();
    }

    public Optional<InFlightAppend> tryAcquire() {
        Optional<InFlightAppend> inFlightAppend = this.limiter.acquire(null).map(limiterListener -> new InFlightAppend(this.errorHandler, (Limiter.Listener)limiterListener, this.metrics));
        if (inFlightAppend.isEmpty()) {
            this.metrics.increaseDeferredAppends();
            LOG.trace("Skipping append due to backpressure");
        }
        return inFlightAppend;
    }

    private Limiter<Void> configureLimiter() {
        Environment env = new Environment();
        boolean isBackpressureEnabled = env.getBool("ZEEBE_BP_APPENDER").orElse(true);
        if (!isBackpressureEnabled) {
            return new NoopLimiter(this.metrics);
        }
        String algorithmName = env.get("ZEEBE_BP_APPENDER_ALGORITHM").orElse("vegas").toLowerCase();
        BackpressureCfg algorithmCfg = ALGORITHM_CFG.getOrDefault(algorithmName, new BackpressureCfgVegas());
        algorithmCfg.applyEnvironment(env);
        AbstractLimit abstractLimit = (AbstractLimit)algorithmCfg.get();
        Boolean windowedLimiter = env.getBool("ZEEBE_BP_APPENDER_WINDOWED").orElse(false);
        LOG.debug("Configured log appender back pressure as {}. Window limiting is {}", (Object)algorithmCfg, (Object)(windowedLimiter != false ? "enabled" : "disabled"));
        return ((AppendLimiter.AppenderLimiterBuilder)AppendLimiter.builder().limit((Limit)(windowedLimiter != false ? WindowedLimit.newBuilder().build((Limit)abstractLimit) : abstractLimit))).metrics(this.metrics).build();
    }
}

