/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.log.LogEntryDescriptor;
import io.camunda.zeebe.logstreams.impl.serializer.DataFrameDescriptor;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.util.buffer.BufferReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class LoggedEventImpl
implements LoggedEvent {
    private DirectBuffer buffer;
    private int fragmentOffset = -1;
    private int messageOffset = -1;

    public void wrap(DirectBuffer buffer, int offset) {
        this.fragmentOffset = offset;
        this.messageOffset = offset + 12;
        this.buffer = buffer;
    }

    public DirectBuffer getBuffer() {
        return this.buffer;
    }

    public int getFragmentLength() {
        return LogEntryDescriptor.getFragmentLength(this.buffer, this.fragmentOffset);
    }

    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    @Override
    public boolean shouldSkipProcessing() {
        return LogEntryDescriptor.shouldSkipProcessing(this.buffer, this.messageOffset);
    }

    @Override
    public long getPosition() {
        return LogEntryDescriptor.getPosition(this.buffer, this.fragmentOffset);
    }

    @Override
    public long getSourceEventPosition() {
        return LogEntryDescriptor.getSourceEventPosition(this.buffer, this.messageOffset);
    }

    @Override
    public long getKey() {
        return LogEntryDescriptor.getKey(this.buffer, this.messageOffset);
    }

    @Override
    public long getTimestamp() {
        return LogEntryDescriptor.getTimestamp(this.buffer, this.messageOffset);
    }

    @Override
    public DirectBuffer getMetadata() {
        return this.buffer;
    }

    @Override
    public int getMetadataOffset() {
        return LogEntryDescriptor.metadataOffset(this.messageOffset);
    }

    @Override
    public short getMetadataLength() {
        return LogEntryDescriptor.getMetadataLength(this.buffer, this.messageOffset);
    }

    @Override
    public void readMetadata(BufferReader reader) {
        reader.wrap(this.buffer, this.getMetadataOffset(), (int)this.getMetadataLength());
    }

    @Override
    public DirectBuffer getValueBuffer() {
        return this.buffer;
    }

    @Override
    public int getValueOffset() {
        short metadataLength = this.getMetadataLength();
        return LogEntryDescriptor.valueOffset(this.messageOffset, metadataLength);
    }

    @Override
    public int getValueLength() {
        short metadataLength = this.getMetadataLength();
        return this.getMessageLength() - LogEntryDescriptor.headerLength(metadataLength);
    }

    @Override
    public void readValue(BufferReader reader) {
        reader.wrap(this.buffer, this.getValueOffset(), this.getValueLength());
    }

    public String toString() {
        return "LoggedEvent [position=" + this.getPosition() + ", key=" + this.getKey() + ", timestamp=" + this.getTimestamp() + ", sourceEventPosition=" + this.getSourceEventPosition() + "]";
    }

    public int getLength() {
        return this.getFragmentLength();
    }

    public void write(MutableDirectBuffer destination, int offset) {
        destination.putBytes(offset, this.buffer, this.fragmentOffset, this.getLength());
    }

    private int getMessageLength() {
        return DataFrameDescriptor.messageLength(this.buffer.getInt(DataFrameDescriptor.lengthOffset(this.fragmentOffset), Protocol.ENDIANNESS));
    }
}

