/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.Gradient2Limit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.BackpressureCfg;
import io.camunda.zeebe.util.Environment;

final class BackpressureCfgGradient2
implements BackpressureCfg {
    private int initialLimit = 1024;
    private int maxConcurrency = 32768;
    private int queueSize = 32;
    private int minLimit = 256;
    private int longWindow = 1200;
    private double rttTolerance = 1.5;

    BackpressureCfgGradient2() {
    }

    @Override
    public void applyEnvironment(Environment environment) {
        environment.getInt("ZEEBE_BP_APPENDER_GRADIENT2_INIT_LIMIT").ifPresent(this::setInitialLimit);
        environment.getInt("ZEEBE_BP_APPENDER_GRADIENT2_MAX_CONCURRENCY").ifPresent(this::setMaxConcurrency);
        environment.getInt("ZEEBE_BP_APPENDER_GRADIENT2_QUEUE_SIZE").ifPresent(this::setQueueSize);
        environment.getInt("ZEEBE_BP_APPENDER_VEGAS_BETA_LIMIT").ifPresent(this::setMinLimit);
        environment.getInt("ZEEBE_BP_APPENDER_GRADIENT2_LONG_WINDOW").ifPresent(this::setLongWindow);
        environment.getDouble("ZEEBE_BP_APPENDER_GRADIENT2_RTT_TOLERANCE").ifPresent(this::setRttTolerance);
    }

    public int getInitialLimit() {
        return this.initialLimit;
    }

    public BackpressureCfgGradient2 setInitialLimit(int initialLimit) {
        this.initialLimit = initialLimit;
        return this;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public BackpressureCfgGradient2 setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public BackpressureCfgGradient2 setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    public int getMinLimit() {
        return this.minLimit;
    }

    public BackpressureCfgGradient2 setMinLimit(int minLimit) {
        this.minLimit = minLimit;
        return this;
    }

    public int getLongWindow() {
        return this.longWindow;
    }

    public BackpressureCfgGradient2 setLongWindow(int longWindow) {
        this.longWindow = longWindow;
        return this;
    }

    public double getRttTolerance() {
        return this.rttTolerance;
    }

    public BackpressureCfgGradient2 setRttTolerance(double rttTolerance) {
        this.rttTolerance = rttTolerance;
        return this;
    }

    @Override
    public AbstractLimit get() {
        return Gradient2Limit.newBuilder().initialLimit(this.initialLimit).maxConcurrency(this.maxConcurrency).queueSize(this.queueSize).minLimit(this.minLimit).longWindow(this.longWindow).rttTolerance(this.rttTolerance).build();
    }

    public String toString() {
        return "BackpressureCfgGradient2{initialLimit=" + this.initialLimit + ", maxConcurrency=" + this.maxConcurrency + ", queueSize=" + this.queueSize + ", minLimit=" + this.minLimit + ", longWindow=" + this.longWindow + ", rttTolerance=" + this.rttTolerance + "}";
    }
}

