/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.google.common.util.concurrent.RateLimiter;
import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import io.camunda.zeebe.logstreams.impl.LogStreamMetrics;
import io.camunda.zeebe.logstreams.impl.flowcontrol.InFlightEntry;
import io.camunda.zeebe.logstreams.impl.flowcontrol.NoopLimiter;
import io.camunda.zeebe.logstreams.impl.flowcontrol.RateLimit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.RateLimitThrottle;
import io.camunda.zeebe.logstreams.impl.flowcontrol.RateMeasurement;
import io.camunda.zeebe.logstreams.impl.flowcontrol.RequestLimiter;
import io.camunda.zeebe.logstreams.impl.flowcontrol.StabilizingAIMDLimit;
import io.camunda.zeebe.logstreams.impl.log.LogAppendEntryMetadata;
import io.camunda.zeebe.logstreams.log.WriteContext;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;

public final class FlowControl
implements LogStorage.AppendListener {
    private final LogStreamMetrics metrics;
    private RateLimit writeRateLimit;
    private Limit requestLimit;
    private Limiter<Intent> processingLimiter;
    private RateLimiter writeRateLimiter;
    private final RateMeasurement exportingRate = new RateMeasurement(ActorClock::currentTimeMillis, Duration.ofMinutes(5L), Duration.ofSeconds(10L));
    private final RateMeasurement writeRate = new RateMeasurement(ActorClock::currentTimeMillis, Duration.ofMinutes(5L), Duration.ofSeconds(10L));
    private RateLimitThrottle writeRateThrottle;
    private volatile long lastWrittenPosition = -1L;
    private volatile long lastProcessedPosition = -1L;
    private volatile long lastExportedPosition;
    private final NavigableMap<Long, InFlightEntry> inFlight = new TreeMap<Long, InFlightEntry>();

    public FlowControl(LogStreamMetrics metrics) {
        this(metrics, (Limit)StabilizingAIMDLimit.newBuilder().build(), RateLimit.disabled());
    }

    public FlowControl(LogStreamMetrics metrics, Limit requestLimit, RateLimit writeRateLimit) {
        this.metrics = metrics;
        this.setRequestLimit(requestLimit);
        this.setWriteRateLimit(writeRateLimit);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Either<Rejection, InFlightEntry> tryAcquire(WriteContext context, List<LogAppendEntryMetadata> batchMetadata) {
        Either<Rejection, InFlightEntry> result;
        Either<Rejection, InFlightEntry> either = result = this.tryAcquireInternal(context, batchMetadata);
        Objects.requireNonNull(either);
        Either<Rejection, InFlightEntry> either2 = either;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Either.Left.class, Either.Right.class}, either2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Either.Left left = (Either.Left)either2;
                try {
                    Rejection rejection;
                    Rejection reason = rejection = (Rejection)((Object)left.value());
                    this.metrics.flowControlRejected(context, batchMetadata, reason);
                    return result;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        Either.Right right = (Either.Right)either2;
        {
            InFlightEntry inFlightEntry;
            InFlightEntry ignored = inFlightEntry = (InFlightEntry)right.value();
            this.metrics.flowControlAccepted(context, batchMetadata);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Either<Rejection, InFlightEntry> tryAcquireInternal(WriteContext context, List<LogAppendEntryMetadata> batchMetadata) {
        Limiter.Listener requestListener;
        WriteContext writeContext = context;
        Objects.requireNonNull(writeContext);
        WriteContext writeContext2 = writeContext;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WriteContext.Internal.class, WriteContext.UserCommand.class}, (Object)writeContext2, n)) {
            case 0: {
                WriteContext.Internal ignored = (WriteContext.Internal)writeContext2;
                return Either.right((Object)new InFlightEntry(this.metrics, batchMetadata, null));
            }
            case 1: {
                Intent intent2;
                WriteContext.UserCommand userCommand = (WriteContext.UserCommand)writeContext2;
                try {
                    Intent intent;
                    intent2 = intent = userCommand.intent();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                requestListener = this.processingLimiter.acquire((Object)intent2).orElse(null);
                if (requestListener != null) break;
                return Either.left((Object)((Object)Rejection.RequestLimitExhausted));
            }
            default: {
                requestListener = null;
            }
        }
        if (this.writeRateLimiter != null && !this.writeRateLimiter.tryAcquire(batchMetadata.size())) {
            if (requestListener != null) {
                requestListener.onIgnore();
            }
            return Either.left((Object)((Object)Rejection.WriteRateLimitExhausted));
        }
        return Either.right((Object)new InFlightEntry(this.metrics, batchMetadata, requestListener));
    }

    public void onAppend(InFlightEntry entry, long highestPosition) {
        entry.onAppend();
        this.metrics.increaseInflightAppends();
        NavigableMap<Long, InFlightEntry> clearable = this.inFlight.headMap(this.lastProcessedPosition, true);
        clearable.forEach((position, inFlightEntry) -> inFlightEntry.cleanup());
        clearable.clear();
        this.inFlight.put(highestPosition, entry);
    }

    @Override
    public void onWrite(long index, long highestPosition) {
        this.lastWrittenPosition = highestPosition;
        this.updateWriteRateThrottle();
        this.metrics.setLastWrittenPosition(highestPosition);
        InFlightEntry inFlightEntry = (InFlightEntry)this.inFlight.get(highestPosition);
        if (inFlightEntry != null) {
            inFlightEntry.onWrite();
        }
        if (this.writeRate.observe(highestPosition) && this.writeRateLimit != null && this.writeRateLimit.enabled()) {
            this.metrics.setPartitionLoad(Math.min((float)((double)this.writeRate.rate() / this.writeRateLimiter.getRate() * 100.0), 100.0f));
        }
    }

    @Override
    public void onCommit(long index, long highestPosition) {
        this.metrics.setLastCommittedPosition(highestPosition);
        this.metrics.decreaseInflightAppends();
        InFlightEntry inFlightEntry = (InFlightEntry)this.inFlight.get(highestPosition);
        if (inFlightEntry != null) {
            inFlightEntry.onCommit();
        }
    }

    public void onProcessed(long position) {
        InFlightEntry inFlightEntry = (InFlightEntry)this.inFlight.get(position);
        if (inFlightEntry != null) {
            inFlightEntry.onProcessed();
        }
        this.lastProcessedPosition = position;
    }

    public void onExported(long position) {
        if (position <= 0L) {
            return;
        }
        this.lastExportedPosition = position;
        if (this.exportingRate.observe(position)) {
            this.metrics.setExportingRate(this.exportingRate.rate());
        }
        this.updateWriteRateThrottle();
    }

    private void updateWriteRateThrottle() {
        if (this.writeRateThrottle != null && this.lastWrittenPosition != -1L && this.lastExportedPosition != -1L) {
            this.writeRateThrottle.update(ActorClock.currentTimeMillis(), this.lastWrittenPosition - this.lastExportedPosition);
        }
    }

    public Limit getRequestLimit() {
        return this.requestLimit;
    }

    public void setRequestLimit(Limit requestLimit) {
        this.requestLimit = requestLimit;
        this.processingLimiter = requestLimit != null ? ((RequestLimiter.CommandRateLimiterBuilder)new RequestLimiter.CommandRateLimiterBuilder().limit(requestLimit)).build(this.metrics) : new NoopLimiter<Intent>();
    }

    public RateLimit getWriteRateLimit() {
        return this.writeRateLimit;
    }

    public void setWriteRateLimit(RateLimit writeRateLimit) {
        this.writeRateLimit = writeRateLimit;
        this.writeRateLimiter = writeRateLimit == null ? null : writeRateLimit.limiter();
        this.writeRateThrottle = new RateLimitThrottle(this.metrics, writeRateLimit, this.writeRateLimiter, this.exportingRate);
        if (writeRateLimit == null || !writeRateLimit.enabled()) {
            this.metrics.setPartitionLoad(-1.0f);
        }
    }

    public static enum Rejection {
        WriteRateLimitExhausted,
        RequestLimitExhausted;

    }
}

