/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack;

import io.camunda.zeebe.msgpack.Recyclable;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.ObjectValue;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class UnpackedObject
extends ObjectValue
implements Recyclable,
BufferReader,
BufferWriter {
    protected final MsgPackReader reader = new MsgPackReader();
    protected final MsgPackWriter writer = new MsgPackWriter();

    public UnpackedObject(int expectedDeclaredProperties) {
        super(expectedDeclaredProperties);
    }

    public void wrap(DirectBuffer buff) {
        this.wrap(buff, 0, buff.capacity());
    }

    public void wrap(DirectBuffer buff, int offset, int length) {
        this.reset();
        this.reader.wrap(buff, offset, length);
        try {
            this.read(this.reader);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deserialize object [" + this.getClass().getSimpleName() + "]. Deserialization stuck at offset " + this.reader.getOffset() + " of length " + length, e);
        }
    }

    public int getLength() {
        return this.getEncodedLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.writer.wrap(buffer, offset);
        this.write(this.writer);
    }
}

