/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class JobRecordStreamFilter {
    private final Stream<Record<JobRecordValue>> stream;

    public JobRecordStreamFilter(Iterable<Record<JobRecordValue>> records) {
        this.stream = StreamSupport.stream(records.spliterator(), false);
    }

    public JobRecordStreamFilter(Stream<Record<JobRecordValue>> stream) {
        this.stream = stream;
    }

    public JobRecordStreamFilter withKey(long key) {
        return new JobRecordStreamFilter(this.stream.filter(record -> record.getKey() == key));
    }

    public JobRecordStreamFilter withIntent(JobIntent intent) {
        return new JobRecordStreamFilter(this.stream.filter(record -> record.getIntent() == intent));
    }

    public JobRecordStreamFilter withElementId(String elementId) {
        return new JobRecordStreamFilter(this.stream.filter(record -> ((JobRecordValue)record.getValue()).getElementId().equals(elementId)));
    }

    public Stream<Record<JobRecordValue>> stream() {
        return this.stream;
    }
}

