/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MessageRecordStreamFilter {
    private final Stream<Record<MessageRecordValue>> stream;

    public MessageRecordStreamFilter(Iterable<Record<MessageRecordValue>> messageRecords) {
        this.stream = StreamSupport.stream(messageRecords.spliterator(), false);
    }

    public MessageRecordStreamFilter(Stream<Record<MessageRecordValue>> stream) {
        this.stream = stream;
    }

    public MessageRecordStreamFilter withKey(long key) {
        return new MessageRecordStreamFilter(this.stream.filter(record -> record.getKey() == key));
    }

    public MessageRecordStreamFilter withMessageName(String messageName) {
        return new MessageRecordStreamFilter(this.stream.filter(record -> ((MessageRecordValue)record.getValue()).getName().equals(messageName)));
    }

    public MessageRecordStreamFilter withCorrelationKey(String correlationKey) {
        return new MessageRecordStreamFilter(this.stream.filter(record -> ((MessageRecordValue)record.getValue()).getCorrelationKey().equals(correlationKey)));
    }

    public MessageRecordStreamFilter withIntent(MessageIntent intent) {
        return new MessageRecordStreamFilter(this.stream.filter(record -> record.getIntent() == intent));
    }

    public MessageRecordStreamFilter withRejectionType(RejectionType rejectionType) {
        return new MessageRecordStreamFilter(this.stream.filter(record -> record.getRejectionType() == rejectionType));
    }

    public Stream<Record<MessageRecordValue>> stream() {
        return this.stream;
    }
}

