/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ProcessRecordStreamFilter {
    private final Stream<Record<Process>> stream;

    public ProcessRecordStreamFilter(Iterable<Record<Process>> records) {
        this.stream = StreamSupport.stream(records.spliterator(), false);
    }

    public ProcessRecordStreamFilter(Stream<Record<Process>> stream) {
        this.stream = stream;
    }

    public Stream<Process> getProcessDefinitions() {
        return this.stream.map(Record::getValue);
    }

    public ProcessRecordStreamFilter withBpmnProcessId(String bpmnProcessId) {
        return new ProcessRecordStreamFilter(this.stream.filter(record -> Objects.equals(((Process)record.getValue()).getBpmnProcessId(), bpmnProcessId)));
    }

    public ProcessRecordStreamFilter withDeployment(DeploymentEvent deployment) {
        return new ProcessRecordStreamFilter(this.stream.filter(record -> deployment.getProcesses().stream().anyMatch(process -> process.getProcessDefinitionKey() == ((Process)record.getValue()).getProcessDefinitionKey())));
    }

    public ProcessRecordStreamFilter withIntent(ProcessIntent intent) {
        return new ProcessRecordStreamFilter(this.stream.filter(record -> record.getIntent().equals((Object)intent)));
    }

    public Stream<Record<Process>> stream() {
        return this.stream;
    }
}

