/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.usertask;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.PackedProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class UserTaskRecord
extends UnifiedRecordValue
implements UserTaskRecordValue {
    public static final DirectBuffer NO_HEADERS = new UnsafeBuffer(MsgPackHelper.EMTPY_OBJECT);
    public static final String CANDIDATE_GROUPS = "candidateGroupsList";
    public static final String CANDIDATE_USERS = "candidateUsersList";
    public static final String DUE_DATE = "dueDate";
    public static final String FOLLOW_UP_DATE = "followUpDate";
    private static final String EMPTY_STRING = "";
    private static final StringValue CANDIDATE_GROUPS_VALUE = new StringValue("candidateGroupsList");
    private static final StringValue CANDIDATE_USERS_VALUE = new StringValue("candidateUsersList");
    private static final StringValue DUE_DATE_VALUE = new StringValue("dueDate");
    private static final StringValue FOLLOW_UP_DATE_VALUE = new StringValue("followUpDate");
    private final LongProperty userTaskKeyProp = new LongProperty("userTaskKey", -1L);
    private final StringProperty assigneeProp = new StringProperty("assignee", "");
    private final ArrayProperty<StringValue> candidateGroupsListProp = new ArrayProperty("candidateGroupsList", StringValue::new);
    private final ArrayProperty<StringValue> candidateUsersListProp = new ArrayProperty("candidateUsersList", StringValue::new);
    private final StringProperty dueDateProp = new StringProperty("dueDate", "");
    private final StringProperty followUpDateProp = new StringProperty("followUpDate", "");
    private final LongProperty formKeyProp = new LongProperty("formKey", -1L);
    private final StringProperty externalFormReferenceProp = new StringProperty("externalFormReference", "");
    private final DocumentProperty variableProp = new DocumentProperty("variables");
    private final PackedProperty customHeadersProp = new PackedProperty("customHeaders", NO_HEADERS);
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final IntegerProperty processDefinitionVersionProp = new IntegerProperty("processDefinitionVersion", -1);
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey", -1L);
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey", -1L);
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");
    private final ArrayProperty<StringValue> changedAttributesProp = new ArrayProperty("changedAttributes", StringValue::new);
    private final StringProperty actionProp = new StringProperty("action", "");
    private final LongProperty creationTimestampProp = new LongProperty("creationTimestamp", -1L);

    public UserTaskRecord() {
        super(20);
        this.declareProperty((BaseProperty)this.userTaskKeyProp).declareProperty((BaseProperty)this.assigneeProp).declareProperty(this.candidateGroupsListProp).declareProperty(this.candidateUsersListProp).declareProperty((BaseProperty)this.dueDateProp).declareProperty((BaseProperty)this.followUpDateProp).declareProperty((BaseProperty)this.formKeyProp).declareProperty((BaseProperty)this.externalFormReferenceProp).declareProperty((BaseProperty)this.variableProp).declareProperty((BaseProperty)this.customHeadersProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.processDefinitionVersionProp).declareProperty((BaseProperty)this.processDefinitionKeyProp).declareProperty((BaseProperty)this.processInstanceKeyProp).declareProperty((BaseProperty)this.elementIdProp).declareProperty((BaseProperty)this.elementInstanceKeyProp).declareProperty((BaseProperty)this.tenantIdProp).declareProperty(this.changedAttributesProp).declareProperty((BaseProperty)this.actionProp).declareProperty((BaseProperty)this.creationTimestampProp);
    }

    public void wrapWithoutVariables(UserTaskRecord record) {
        this.userTaskKeyProp.setValue(record.getUserTaskKey());
        this.assigneeProp.setValue(record.getAssigneeBuffer());
        this.setCandidateGroupsList(record.getCandidateGroupsList());
        this.setCandidateUsersList(record.getCandidateUsersList());
        this.dueDateProp.setValue(record.getDueDateBuffer());
        this.followUpDateProp.setValue(record.getFollowUpDateBuffer());
        this.formKeyProp.setValue(record.getFormKey());
        this.externalFormReferenceProp.setValue(record.getExternalFormReferenceBuffer());
        DirectBuffer customHeaders = record.getCustomHeadersBuffer();
        this.customHeadersProp.setValue(customHeaders, 0, customHeaders.capacity());
        this.bpmnProcessIdProp.setValue(record.getBpmnProcessIdBuffer());
        this.processDefinitionVersionProp.setValue(record.getProcessDefinitionVersion());
        this.processDefinitionKeyProp.setValue(record.getProcessDefinitionKey());
        this.processInstanceKeyProp.setValue(record.getProcessInstanceKey());
        this.elementIdProp.setValue(record.getElementIdBuffer());
        this.elementInstanceKeyProp.setValue(record.getElementInstanceKey());
        this.tenantIdProp.setValue(record.getTenantIdBuffer());
        this.creationTimestampProp.setValue(record.getCreationTimestamp());
        this.setChangedAttributesProp(record.getChangedAttributesProp());
        this.actionProp.setValue(record.getActionBuffer());
    }

    public void wrapChangedAttributes(UserTaskRecord record, boolean includeTrackingProperties) {
        record.getChangedAttributesProp().stream().forEach(attribute -> this.updateAttribute((StringValue)attribute, record));
        if (includeTrackingProperties) {
            this.setChangedAttributesProp(record.getChangedAttributesProp());
        }
    }

    private void updateAttribute(StringValue attribute, UserTaskRecord record) {
        switch (BufferUtil.bufferAsString((DirectBuffer)attribute.getValue())) {
            case "candidateGroupsList": {
                this.setCandidateGroupsList(record.getCandidateGroupsList());
                break;
            }
            case "candidateUsersList": {
                this.setCandidateUsersList(record.getCandidateUsersList());
                break;
            }
            case "dueDate": {
                this.dueDateProp.setValue(record.getDueDateBuffer());
                break;
            }
            case "followUpDate": {
                this.followUpDateProp.setValue(record.getFollowUpDateBuffer());
                break;
            }
        }
    }

    public long getUserTaskKey() {
        return this.userTaskKeyProp.getValue();
    }

    public String getAssignee() {
        return BufferUtil.bufferAsString((DirectBuffer)this.assigneeProp.getValue());
    }

    public List<String> getCandidateGroupsList() {
        return StreamSupport.stream(this.candidateGroupsListProp.spliterator(), false).map(StringValue::getValue).map(BufferUtil::bufferAsString).collect(Collectors.toList());
    }

    public List<String> getCandidateUsersList() {
        return StreamSupport.stream(this.candidateUsersListProp.spliterator(), false).map(StringValue::getValue).map(BufferUtil::bufferAsString).collect(Collectors.toList());
    }

    public String getDueDate() {
        return BufferUtil.bufferAsString((DirectBuffer)this.dueDateProp.getValue());
    }

    public String getFollowUpDate() {
        return BufferUtil.bufferAsString((DirectBuffer)this.followUpDateProp.getValue());
    }

    public long getFormKey() {
        return this.formKeyProp.getValue();
    }

    public List<String> getChangedAttributes() {
        return StreamSupport.stream(this.changedAttributesProp.spliterator(), false).map(StringValue::getValue).map(BufferUtil::bufferAsString).collect(Collectors.toList());
    }

    public String getAction() {
        return BufferUtil.bufferAsString((DirectBuffer)this.actionProp.getValue());
    }

    public String getExternalFormReference() {
        return BufferUtil.bufferAsString((DirectBuffer)this.externalFormReferenceProp.getValue());
    }

    public Map<String, String> getCustomHeaders() {
        return MsgPackConverter.convertToStringMap(this.customHeadersProp.getValue());
    }

    public long getCreationTimestamp() {
        return this.creationTimestampProp.getValue();
    }

    public String getElementId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.elementIdProp.getValue());
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersionProp.getValue();
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    public UserTaskRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProp.setValue(processDefinitionKey);
        return this;
    }

    public UserTaskRecord setProcessDefinitionVersion(int version) {
        this.processDefinitionVersionProp.setValue(version);
        return this;
    }

    public UserTaskRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public UserTaskRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public UserTaskRecord setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKeyProp.setValue(elementInstanceKey);
        return this;
    }

    public UserTaskRecord setElementId(String elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public UserTaskRecord setElementId(DirectBuffer elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public UserTaskRecord setCreationTimestamp(long creationTimestamp) {
        this.creationTimestampProp.setValue(creationTimestamp);
        return this;
    }

    public UserTaskRecord setCustomHeaders(DirectBuffer buffer) {
        this.customHeadersProp.setValue(buffer, 0, buffer.capacity());
        return this;
    }

    public UserTaskRecord setExternalFormReference(DirectBuffer externalFormReference) {
        this.externalFormReferenceProp.setValue(externalFormReference);
        return this;
    }

    public UserTaskRecord setExternalFormReference(String externalFormReference) {
        this.externalFormReferenceProp.setValue(externalFormReference);
        return this;
    }

    public UserTaskRecord setAction(String action) {
        this.actionProp.setValue(action);
        return this;
    }

    public UserTaskRecord setAction(DirectBuffer action) {
        this.actionProp.setValue(action);
        return this;
    }

    public UserTaskRecord setChangedAttributes(List<String> changedAttributes) {
        this.changedAttributesProp.reset();
        changedAttributes.forEach(attribute -> ((StringValue)this.changedAttributesProp.add()).wrap(BufferUtil.wrapString((String)attribute)));
        return this;
    }

    public UserTaskRecord setFormKey(long formKey) {
        this.formKeyProp.setValue(formKey);
        return this;
    }

    public UserTaskRecord setFollowUpDate(String followUpDate) {
        this.followUpDateProp.setValue(followUpDate);
        return this;
    }

    public UserTaskRecord setFollowUpDate(DirectBuffer followUpDate) {
        this.followUpDateProp.setValue(followUpDate);
        return this;
    }

    public UserTaskRecord setDueDate(String dueDate) {
        this.dueDateProp.setValue(dueDate);
        return this;
    }

    public UserTaskRecord setDueDate(DirectBuffer dueDate) {
        this.dueDateProp.setValue(dueDate);
        return this;
    }

    public UserTaskRecord setCandidateUsersList(List<String> candidateUsers) {
        this.candidateUsersListProp.reset();
        candidateUsers.forEach(tenantId -> ((StringValue)this.candidateUsersListProp.add()).wrap(BufferUtil.wrapString((String)tenantId)));
        return this;
    }

    public UserTaskRecord setCandidateGroupsList(List<String> candidateGroups) {
        this.candidateGroupsListProp.reset();
        candidateGroups.forEach(tenantId -> ((StringValue)this.candidateGroupsListProp.add()).wrap(BufferUtil.wrapString((String)tenantId)));
        return this;
    }

    public UserTaskRecord setAssignee(String assignee) {
        this.assigneeProp.setValue(assignee);
        return this;
    }

    public UserTaskRecord setAssignee(DirectBuffer assignee) {
        this.assigneeProp.setValue(assignee);
        return this;
    }

    public UserTaskRecord setUserTaskKey(long userTaskKey) {
        this.userTaskKeyProp.setValue(userTaskKey);
        return this;
    }

    public UserTaskRecord setCandidateGroupsChanged() {
        ((StringValue)this.changedAttributesProp.add()).wrap(CANDIDATE_GROUPS_VALUE);
        return this;
    }

    public UserTaskRecord setCandidateUsersChanged() {
        ((StringValue)this.changedAttributesProp.add()).wrap(CANDIDATE_USERS_VALUE);
        return this;
    }

    public UserTaskRecord setDueDateChanged() {
        ((StringValue)this.changedAttributesProp.add()).wrap(DUE_DATE_VALUE);
        return this;
    }

    public UserTaskRecord setFollowUpDateChanged() {
        ((StringValue)this.changedAttributesProp.add()).wrap(FOLLOW_UP_DATE_VALUE);
        return this;
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public UserTaskRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variableProp.getValue());
    }

    public UserTaskRecord setVariables(DirectBuffer variables) {
        this.variableProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getCustomHeadersBuffer() {
        return this.customHeadersProp.getValue();
    }

    @JsonIgnore
    public ArrayProperty<StringValue> getChangedAttributesProp() {
        return this.changedAttributesProp;
    }

    public UserTaskRecord setChangedAttributesProp(ArrayProperty<StringValue> changedAttributes) {
        this.changedAttributesProp.reset();
        changedAttributes.forEach(attribute -> ((StringValue)this.changedAttributesProp.add()).wrap(attribute));
        return this;
    }

    @JsonIgnore
    public DirectBuffer getAssigneeBuffer() {
        return this.assigneeProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDueDateBuffer() {
        return this.dueDateProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getFollowUpDateBuffer() {
        return this.followUpDateProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variableProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getExternalFormReferenceBuffer() {
        return this.externalFormReferenceProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getTenantIdBuffer() {
        return this.tenantIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getActionBuffer() {
        return this.actionProp.getValue();
    }

    @JsonIgnore
    public String getActionOrDefault(String defaultAction) {
        String action = BufferUtil.bufferAsString((DirectBuffer)this.actionProp.getValue());
        return action.isEmpty() ? defaultAction : action;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public UserTaskRecord setProcessInstanceKey(long key) {
        this.processInstanceKeyProp.setValue(key);
        return this;
    }
}

