/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.record.ExecuteQueryResponseDecoder;
import io.camunda.zeebe.protocol.record.ExecuteQueryResponseEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ExecuteQueryResponse
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ExecuteQueryResponseEncoder bodyEncoder = new ExecuteQueryResponseEncoder();
    private final ExecuteQueryResponseDecoder bodyDecoder = new ExecuteQueryResponseDecoder();
    private final DirectBuffer rawBpmnProcessId = new UnsafeBuffer();

    public ExecuteQueryResponse() {
        this.reset();
    }

    public ExecuteQueryResponse reset() {
        this.rawBpmnProcessId.wrap(0L, 0);
        return this;
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.rawBpmnProcessId);
    }

    public ExecuteQueryResponse setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.rawBpmnProcessId.wrap(bpmnProcessId);
        return this;
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.bodyEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder).putBpmnProcessId(this.rawBpmnProcessId, 0, this.rawBpmnProcessId.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.bodyDecoder.wrapAndApplyHeader(buffer, offset, this.headerDecoder);
        this.bodyDecoder.wrapBpmnProcessId(this.rawBpmnProcessId);
    }
}

