package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommandDistributionRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommandDistributionRecordValue.builder()}.
 */
@Generated(from = "CommandDistributionRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableCommandDistributionRecordValue.Builder.class)
public final class ImmutableCommandDistributionRecordValue
    implements CommandDistributionRecordValue {
  private final int partitionId;
  private final ValueType valueType;
  private final RecordValue commandValue;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableCommandDistributionRecordValue(
      int partitionId,
      ValueType valueType,
      RecordValue commandValue) {
    this.partitionId = partitionId;
    this.valueType = valueType;
    this.commandValue = commandValue;
  }

  /**
   * @return the partition where the record should be distributed to
   */
  @Override
  public int getPartitionId() {
    return partitionId;
  }

  /**
   * @return the wrapped record value type
   */
  @Override
  public ValueType getValueType() {
    return valueType;
  }

  /**
   * @return the wrapped record value
   */
  @Override
  public RecordValue getCommandValue() {
    return commandValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommandDistributionRecordValue#getPartitionId() partitionId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for partitionId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommandDistributionRecordValue withPartitionId(int value) {
    if (this.partitionId == value) return this;
    return new ImmutableCommandDistributionRecordValue(value, this.valueType, this.commandValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommandDistributionRecordValue#getValueType() valueType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommandDistributionRecordValue withValueType(ValueType value) {
    if (this.valueType == value) return this;
    return new ImmutableCommandDistributionRecordValue(this.partitionId, value, this.commandValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommandDistributionRecordValue#getCommandValue() commandValue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commandValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommandDistributionRecordValue withCommandValue(RecordValue value) {
    if (this.commandValue == value) return this;
    return new ImmutableCommandDistributionRecordValue(this.partitionId, this.valueType, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommandDistributionRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommandDistributionRecordValue
        && equalTo(0, (ImmutableCommandDistributionRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableCommandDistributionRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return partitionId == another.partitionId
        && Objects.equals(valueType, another.valueType)
        && Objects.equals(commandValue, another.commandValue);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code partitionId}, {@code valueType}, {@code commandValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + partitionId;
    h += (h << 5) + Objects.hashCode(valueType);
    h += (h << 5) + Objects.hashCode(commandValue);
    return h;
  }

  /**
   * Prints the immutable value {@code CommandDistributionRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CommandDistributionRecordValue{"
        + "partitionId=" + partitionId
        + ", valueType=" + valueType
        + ", commandValue=" + commandValue
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link CommandDistributionRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommandDistributionRecordValue instance
   */
  public static ImmutableCommandDistributionRecordValue copyOf(CommandDistributionRecordValue instance) {
    if (instance instanceof ImmutableCommandDistributionRecordValue) {
      return (ImmutableCommandDistributionRecordValue) instance;
    }
    return ImmutableCommandDistributionRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommandDistributionRecordValue ImmutableCommandDistributionRecordValue}.
   * <pre>
   * ImmutableCommandDistributionRecordValue.builder()
   *    .withPartitionId(int) // optional {@link CommandDistributionRecordValue#getPartitionId() partitionId}
   *    .withValueType(io.camunda.zeebe.protocol.record.ValueType | null) // nullable {@link CommandDistributionRecordValue#getValueType() valueType}
   *    .withCommandValue(io.camunda.zeebe.protocol.record.RecordValue | null) // nullable {@link CommandDistributionRecordValue#getCommandValue() commandValue}
   *    .build();
   * </pre>
   * @return A new ImmutableCommandDistributionRecordValue builder
   */
  public static ImmutableCommandDistributionRecordValue.Builder builder() {
    return new ImmutableCommandDistributionRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommandDistributionRecordValue ImmutableCommandDistributionRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommandDistributionRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private int partitionId;
    private @Nullable ValueType valueType;
    private @Nullable RecordValue commandValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CommandDistributionRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CommandDistributionRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      withPartitionId(instance.getPartitionId());
      ValueType valueTypeValue = instance.getValueType();
      if (valueTypeValue != null) {
        withValueType(valueTypeValue);
      }
      RecordValue commandValueValue = instance.getCommandValue();
      if (commandValueValue != null) {
        withCommandValue(commandValueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CommandDistributionRecordValue#getPartitionId() partitionId} attribute.
     * @param partitionId The value for partitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }

    /**
     * Initializes the value for the {@link CommandDistributionRecordValue#getValueType() valueType} attribute.
     * @param valueType The value for valueType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withValueType(ValueType valueType) {
      this.valueType = valueType;
      return this;
    }

    /**
     * Initializes the value for the {@link CommandDistributionRecordValue#getCommandValue() commandValue} attribute.
     * @param commandValue The value for commandValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCommandValue(RecordValue commandValue) {
      this.commandValue = commandValue;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.partitionId = 0;
      this.valueType = null;
      this.commandValue = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommandDistributionRecordValue ImmutableCommandDistributionRecordValue}.
     * @return An immutable instance of CommandDistributionRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommandDistributionRecordValue build() {
      return new ImmutableCommandDistributionRecordValue(partitionId, valueType, commandValue);
    }



  }



}
