package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceCreationRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceCreationRecordValue.builder()}.
 */
@Generated(from = "ProcessInstanceCreationRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableProcessInstanceCreationRecordValue.Builder.class)
public final class ImmutableProcessInstanceCreationRecordValue
    implements ProcessInstanceCreationRecordValue {
  private final Map<String, Object> variables;
  private final long processInstanceKey;
  private final String tenantId;
  private final String bpmnProcessId;
  private final int version;
  private final long processDefinitionKey;
  private final List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> startInstructions;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceCreationRecordValue(
      Map<String, Object> variables,
      long processInstanceKey,
      String tenantId,
      String bpmnProcessId,
      int version,
      long processDefinitionKey,
      List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> startInstructions) {
    this.variables = variables;
    this.processInstanceKey = processInstanceKey;
    this.tenantId = tenantId;
    this.bpmnProcessId = bpmnProcessId;
    this.version = version;
    this.processDefinitionKey = processDefinitionKey;
    this.startInstructions = startInstructions;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   * @return the key of the corresponding process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the BPMN process id to create a process from
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the version of the BPMN process to create a process from
   */
  @Override
  public int getVersion() {
    return version;
  }

  /**
   * @return the unique key of the BPMN process definition to create a process from
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   *Returns a list of start instructions (if available), or an empty list. 
   */
  @Override
  public List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> getStartInstructions() {
    return startInstructions;
  }

  /**
   * Copy the current immutable object by replacing the {@link ProcessInstanceCreationRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceCreationRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableProcessInstanceCreationRecordValue(
        newValue,
        this.processInstanceKey,
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.startInstructions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceCreationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceCreationRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableProcessInstanceCreationRecordValue(
        this.variables,
        value,
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.startInstructions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceCreationRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceCreationRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableProcessInstanceCreationRecordValue(
        this.variables,
        this.processInstanceKey,
        value,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.startInstructions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceCreationRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceCreationRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableProcessInstanceCreationRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        value,
        this.version,
        this.processDefinitionKey,
        this.startInstructions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceCreationRecordValue#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceCreationRecordValue withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableProcessInstanceCreationRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.bpmnProcessId,
        value,
        this.processDefinitionKey,
        this.startInstructions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceCreationRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceCreationRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableProcessInstanceCreationRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        value,
        this.startInstructions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceCreationRecordValue withStartInstructions(ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue... elements) {
    List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableProcessInstanceCreationRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of startInstructions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceCreationRecordValue withStartInstructions(Iterable<? extends ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> elements) {
    if (this.startInstructions == elements) return this;
    List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableProcessInstanceCreationRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceCreationRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceCreationRecordValue
        && equalTo(0, (ImmutableProcessInstanceCreationRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceCreationRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && processInstanceKey == another.processInstanceKey
        && Objects.equals(tenantId, another.tenantId)
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && version == another.version
        && processDefinitionKey == another.processDefinitionKey
        && startInstructions.equals(another.startInstructions);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code processInstanceKey}, {@code tenantId}, {@code bpmnProcessId}, {@code version}, {@code processDefinitionKey}, {@code startInstructions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + version;
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + startInstructions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceCreationRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceCreationRecordValue{"
        + "variables=" + variables
        + ", processInstanceKey=" + processInstanceKey
        + ", tenantId=" + tenantId
        + ", bpmnProcessId=" + bpmnProcessId
        + ", version=" + version
        + ", processDefinitionKey=" + processDefinitionKey
        + ", startInstructions=" + startInstructions
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceCreationRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceCreationRecordValue instance
   */
  public static ImmutableProcessInstanceCreationRecordValue copyOf(ProcessInstanceCreationRecordValue instance) {
    if (instance instanceof ImmutableProcessInstanceCreationRecordValue) {
      return (ImmutableProcessInstanceCreationRecordValue) instance;
    }
    return ImmutableProcessInstanceCreationRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceCreationRecordValue ImmutableProcessInstanceCreationRecordValue}.
   * <pre>
   * ImmutableProcessInstanceCreationRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link ProcessInstanceCreationRecordValue#getVariables() variables} mappings
   *    .withProcessInstanceKey(long) // optional {@link ProcessInstanceCreationRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withTenantId(String | null) // nullable {@link ProcessInstanceCreationRecordValue#getTenantId() tenantId}
   *    .withBpmnProcessId(String | null) // nullable {@link ProcessInstanceCreationRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withVersion(int) // optional {@link ProcessInstanceCreationRecordValue#getVersion() version}
   *    .withProcessDefinitionKey(long) // optional {@link ProcessInstanceCreationRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .addStartInstruction|addAllStartInstructions(io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue) // {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceCreationRecordValue builder
   */
  public static ImmutableProcessInstanceCreationRecordValue.Builder builder() {
    return new ImmutableProcessInstanceCreationRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceCreationRecordValue ImmutableProcessInstanceCreationRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceCreationRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private long processInstanceKey;
    private String tenantId;
    private String bpmnProcessId;
    private int version;
    private long processDefinitionKey;
    private List<ImmutableProcessInstanceCreationStartInstructionValue.Builder> startInstructions = new ArrayList<ImmutableProcessInstanceCreationStartInstructionValue.Builder>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceCreationRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceCreationRecordValue) {
        ProcessInstanceCreationRecordValue instance = (ProcessInstanceCreationRecordValue) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
        addAllStartInstructions(instance.getStartInstructions());
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        withVersion(instance.getVersion());
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
      }
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Put one entry to the {@link ProcessInstanceCreationRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(String key, Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ProcessInstanceCreationRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ProcessInstanceCreationRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ProcessInstanceCreationRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceCreationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceCreationRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceCreationRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceCreationRecordValue#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersion(int version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceCreationRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Adds one element to {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions} list.
     * @param element A startInstructions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStartInstruction(ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(element);
      this.startInstructions.add(ImmutableProcessInstanceCreationStartInstructionValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions} list.
     * @param elements An array of startInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addStartInstructions(ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue... elements) {
      for (ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(element);
        this.startInstructions.add(ImmutableProcessInstanceCreationStartInstructionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions} list and returns
     * the builder.
     */
    public final ImmutableProcessInstanceCreationStartInstructionValue.Builder addStartInstructionBuilder() {
      ImmutableProcessInstanceCreationStartInstructionValue.Builder builder = ImmutableProcessInstanceCreationStartInstructionValue.builder();
      this.startInstructions.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions} list.
     * @param elements An array of startInstructions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStartInstructionBuilders(ImmutableProcessInstanceCreationStartInstructionValue.Builder... elements) {
      for (ImmutableProcessInstanceCreationStartInstructionValue.Builder element : elements) {
        this.startInstructions.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableProcessInstanceCreationStartInstructionValue.Builder> startInstructionBuilders() {
      return createUnmodifiableList(false, this.startInstructions);
    }

    /**
     * Sets or replaces all elements for {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions} list.
     * @param elements An iterable of startInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withStartInstructions(Iterable<? extends ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> elements) {
      this.startInstructions.clear();
      return addAllStartInstructions(elements);
    }

    /**
     * Adds elements to {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions} list.
     * @param elements An iterable of startInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStartInstructions(Iterable<? extends ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> elements) {
      for (ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(element);
        this.startInstructions.add(ImmutableProcessInstanceCreationStartInstructionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceCreationRecordValue#getStartInstructions() startInstructions} list.
     * @param elements An iterable of startInstructions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStartInstructionBuilders(Iterable<ImmutableProcessInstanceCreationStartInstructionValue.Builder> elements) {
      for (ImmutableProcessInstanceCreationStartInstructionValue.Builder element : elements) {
        this.startInstructions.add(element);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.processInstanceKey = 0;
      this.tenantId = null;
      this.bpmnProcessId = null;
      this.version = 0;
      this.processDefinitionKey = 0;
      this.startInstructions.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceCreationRecordValue ImmutableProcessInstanceCreationRecordValue}.
     * @return An immutable instance of ProcessInstanceCreationRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceCreationRecordValue build() {
      return new ImmutableProcessInstanceCreationRecordValue(
          createUnmodifiableMap(false, false, variables),
          processInstanceKey,
          tenantId,
          bpmnProcessId,
          version,
          processDefinitionKey,
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(startInstructions)));
    }



    
    private static ImmutableProcessInstanceCreationStartInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue( ImmutableProcessInstanceCreationStartInstructionValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    
    private static ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue( ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue value) {
      if (value == null) return null;
      return ImmutableProcessInstanceCreationStartInstructionValue.builder().from(value).build();
    }

    
    private static ImmutableProcessInstanceCreationStartInstructionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue( ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue value) {
      if (value == null) return null;
      return ImmutableProcessInstanceCreationStartInstructionValue.builder().from(value);
    }

    private static List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(Iterable<? extends ImmutableProcessInstanceCreationStartInstructionValue.Builder> builderList) {
      ArrayList<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableProcessInstanceCreationStartInstructionValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(ImmutableProcessInstanceCreationStartInstructionValue.Builder... builderArray) {
      ArrayList<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableProcessInstanceCreationStartInstructionValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutableProcessInstanceCreationStartInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(Iterable<? extends ImmutableProcessInstanceCreationStartInstructionValue> valueList) {
      ArrayList<ImmutableProcessInstanceCreationStartInstructionValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableProcessInstanceCreationStartInstructionValue element : valueList) {
        list.add(ImmutableProcessInstanceCreationStartInstructionValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutableProcessInstanceCreationStartInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(ImmutableProcessInstanceCreationStartInstructionValue... valueArray) {
      ArrayList<ImmutableProcessInstanceCreationStartInstructionValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableProcessInstanceCreationStartInstructionValue element : valueArray) {
        list.add(ImmutableProcessInstanceCreationStartInstructionValue.builder().from(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



  
  private static ImmutableProcessInstanceCreationStartInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue( ImmutableProcessInstanceCreationStartInstructionValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  
  private static ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue( ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue value) {
    if (value == null) return null;
    return ImmutableProcessInstanceCreationStartInstructionValue.builder().from(value).build();
  }

  
  private static ImmutableProcessInstanceCreationStartInstructionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue( ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue value) {
    if (value == null) return null;
    return ImmutableProcessInstanceCreationStartInstructionValue.builder().from(value);
  }

  private static List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(Iterable<? extends ImmutableProcessInstanceCreationStartInstructionValue.Builder> builderList) {
    ArrayList<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableProcessInstanceCreationStartInstructionValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(ImmutableProcessInstanceCreationStartInstructionValue.Builder... builderArray) {
    ArrayList<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableProcessInstanceCreationStartInstructionValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutableProcessInstanceCreationStartInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(Iterable<? extends ImmutableProcessInstanceCreationStartInstructionValue> valueList) {
    ArrayList<ImmutableProcessInstanceCreationStartInstructionValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableProcessInstanceCreationStartInstructionValue element : valueList) {
      list.add(ImmutableProcessInstanceCreationStartInstructionValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutableProcessInstanceCreationStartInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceCreationStartInstructionValue(ImmutableProcessInstanceCreationStartInstructionValue... valueArray) {
    ArrayList<ImmutableProcessInstanceCreationStartInstructionValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableProcessInstanceCreationStartInstructionValue element : valueArray) {
      list.add(ImmutableProcessInstanceCreationStartInstructionValue.builder().from(element));
    }
    return list;
  }
}
