package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeploymentResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeploymentResource.builder()}.
 */
@Generated(from = "DeploymentResource", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableDeploymentResource.Builder.class)
public final class ImmutableDeploymentResource
    implements DeploymentResource {
  private final byte[] resource;
  private final String resourceName;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableDeploymentResource(byte[] resource, String resourceName) {
    this.resource = resource;
    this.resourceName = resourceName;
  }

  /**
   * @return the resource contents
   */
  @Override
  public byte[] getResource() {
    return resource;
  }

  /**
   * @return the name of the resource
   */
  @Override
  public String getResourceName() {
    return resourceName;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeploymentResource#getResource() resource}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for resource
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeploymentResource withResource(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableDeploymentResource(newValue, this.resourceName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeploymentResource#getResourceName() resourceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeploymentResource withResourceName(String value) {
    if (Objects.equals(this.resourceName, value)) return this;
    return new ImmutableDeploymentResource(this.resource, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeploymentResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeploymentResource
        && equalTo(0, (ImmutableDeploymentResource) another);
  }

  private boolean equalTo(int synthetic, ImmutableDeploymentResource another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Arrays.equals(resource, another.resource)
        && Objects.equals(resourceName, another.resourceName);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code resource}, {@code resourceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Arrays.hashCode(resource);
    h += (h << 5) + Objects.hashCode(resourceName);
    return h;
  }

  /**
   * Prints the immutable value {@code DeploymentResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeploymentResource{"
        + "resource=" + Arrays.toString(resource)
        + ", resourceName=" + resourceName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DeploymentResource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeploymentResource instance
   */
  public static ImmutableDeploymentResource copyOf(DeploymentResource instance) {
    if (instance instanceof ImmutableDeploymentResource) {
      return (ImmutableDeploymentResource) instance;
    }
    return ImmutableDeploymentResource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeploymentResource ImmutableDeploymentResource}.
   * <pre>
   * ImmutableDeploymentResource.builder()
   *    .withResource(byte[] | null) // nullable {@link DeploymentResource#getResource() resource}
   *    .withResourceName(String | null) // nullable {@link DeploymentResource#getResourceName() resourceName}
   *    .build();
   * </pre>
   * @return A new ImmutableDeploymentResource builder
   */
  public static ImmutableDeploymentResource.Builder builder() {
    return new ImmutableDeploymentResource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeploymentResource ImmutableDeploymentResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeploymentResource", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private byte[] resource;
    private String resourceName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeploymentResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeploymentResource instance) {
      Objects.requireNonNull(instance, "instance");
      byte[] resourceValue = instance.getResource();
      if (resourceValue != null) {
        withResource(resourceValue);
      }
      String resourceNameValue = instance.getResourceName();
      if (resourceNameValue != null) {
        withResourceName(resourceNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DeploymentResource#getResource() resource} attribute.
     * @param resource The elements for resource
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResource(byte... resource) {
      this.resource = resource;
      return this;
    }

    /**
     * Initializes the value for the {@link DeploymentResource#getResourceName() resourceName} attribute.
     * @param resourceName The value for resourceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceName(String resourceName) {
      this.resourceName = resourceName;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.resource = null;
      this.resourceName = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeploymentResource ImmutableDeploymentResource}.
     * @return An immutable instance of DeploymentResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeploymentResource build() {
      return new ImmutableDeploymentResource(resource, resourceName);
    }



  }



}
