package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MessageStartEventSubscriptionRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMessageStartEventSubscriptionRecordValue.builder()}.
 */
@Generated(from = "MessageStartEventSubscriptionRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableMessageStartEventSubscriptionRecordValue.Builder.class)
public final class ImmutableMessageStartEventSubscriptionRecordValue
    implements MessageStartEventSubscriptionRecordValue {
  private final Map<String, Object> variables;
  private final String tenantId;
  private final long processDefinitionKey;
  private final String bpmnProcessId;
  private final String startEventId;
  private final String messageName;
  private final long processInstanceKey;
  private final String correlationKey;
  private final long messageKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableMessageStartEventSubscriptionRecordValue(
      Map<String, Object> variables,
      String tenantId,
      long processDefinitionKey,
      String bpmnProcessId,
      String startEventId,
      String messageName,
      long processInstanceKey,
      String correlationKey,
      long messageKey) {
    this.variables = variables;
    this.tenantId = tenantId;
    this.processDefinitionKey = processDefinitionKey;
    this.bpmnProcessId = bpmnProcessId;
    this.startEventId = startEventId;
    this.messageName = messageName;
    this.processInstanceKey = processInstanceKey;
    this.correlationKey = correlationKey;
    this.messageKey = messageKey;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the process key tied to the subscription
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * @return the BPMN process id tied to the subscription
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the id of the start event tied to the subscription
   */
  @Override
  public String getStartEventId() {
    return startEventId;
  }

  /**
   * @return the name of the message
   */
  @Override
  public String getMessageName() {
    return messageName;
  }

  /**
   * @return the key of the process instance that was created by this message. It is only set when a
   *     message is correlated to this subscription. Otherwise, it returns -1.
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the correlation key of the message. It is only set when a message is correlated to this
   *     subscription. Otherwise, it returns an empty string.
   */
  @Override
  public String getCorrelationKey() {
    return correlationKey;
  }

  /**
   * @return the key of the message. It is only set when a message is correlated to this
   *     subscription. Otherwise, it returns -1.
   */
  @Override
  public long getMessageKey() {
    return messageKey;
  }

  /**
   * Copy the current immutable object by replacing the {@link MessageStartEventSubscriptionRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMessageStartEventSubscriptionRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableMessageStartEventSubscriptionRecordValue(
        newValue,
        this.tenantId,
        this.processDefinitionKey,
        this.bpmnProcessId,
        this.startEventId,
        this.messageName,
        this.processInstanceKey,
        this.correlationKey,
        this.messageKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageStartEventSubscriptionRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageStartEventSubscriptionRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableMessageStartEventSubscriptionRecordValue(
        this.variables,
        value,
        this.processDefinitionKey,
        this.bpmnProcessId,
        this.startEventId,
        this.messageName,
        this.processInstanceKey,
        this.correlationKey,
        this.messageKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageStartEventSubscriptionRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageStartEventSubscriptionRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableMessageStartEventSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        value,
        this.bpmnProcessId,
        this.startEventId,
        this.messageName,
        this.processInstanceKey,
        this.correlationKey,
        this.messageKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageStartEventSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageStartEventSubscriptionRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableMessageStartEventSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processDefinitionKey,
        value,
        this.startEventId,
        this.messageName,
        this.processInstanceKey,
        this.correlationKey,
        this.messageKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageStartEventSubscriptionRecordValue#getStartEventId() startEventId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for startEventId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageStartEventSubscriptionRecordValue withStartEventId(String value) {
    if (Objects.equals(this.startEventId, value)) return this;
    return new ImmutableMessageStartEventSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processDefinitionKey,
        this.bpmnProcessId,
        value,
        this.messageName,
        this.processInstanceKey,
        this.correlationKey,
        this.messageKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageStartEventSubscriptionRecordValue#getMessageName() messageName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageStartEventSubscriptionRecordValue withMessageName(String value) {
    if (Objects.equals(this.messageName, value)) return this;
    return new ImmutableMessageStartEventSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processDefinitionKey,
        this.bpmnProcessId,
        this.startEventId,
        value,
        this.processInstanceKey,
        this.correlationKey,
        this.messageKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageStartEventSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageStartEventSubscriptionRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableMessageStartEventSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processDefinitionKey,
        this.bpmnProcessId,
        this.startEventId,
        this.messageName,
        value,
        this.correlationKey,
        this.messageKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageStartEventSubscriptionRecordValue#getCorrelationKey() correlationKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for correlationKey (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageStartEventSubscriptionRecordValue withCorrelationKey(String value) {
    if (Objects.equals(this.correlationKey, value)) return this;
    return new ImmutableMessageStartEventSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processDefinitionKey,
        this.bpmnProcessId,
        this.startEventId,
        this.messageName,
        this.processInstanceKey,
        value,
        this.messageKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageStartEventSubscriptionRecordValue#getMessageKey() messageKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageStartEventSubscriptionRecordValue withMessageKey(long value) {
    if (this.messageKey == value) return this;
    return new ImmutableMessageStartEventSubscriptionRecordValue(
        this.variables,
        this.tenantId,
        this.processDefinitionKey,
        this.bpmnProcessId,
        this.startEventId,
        this.messageName,
        this.processInstanceKey,
        this.correlationKey,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMessageStartEventSubscriptionRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMessageStartEventSubscriptionRecordValue
        && equalTo(0, (ImmutableMessageStartEventSubscriptionRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableMessageStartEventSubscriptionRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && Objects.equals(tenantId, another.tenantId)
        && processDefinitionKey == another.processDefinitionKey
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && Objects.equals(startEventId, another.startEventId)
        && Objects.equals(messageName, another.messageName)
        && processInstanceKey == another.processInstanceKey
        && Objects.equals(correlationKey, another.correlationKey)
        && messageKey == another.messageKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code tenantId}, {@code processDefinitionKey}, {@code bpmnProcessId}, {@code startEventId}, {@code messageName}, {@code processInstanceKey}, {@code correlationKey}, {@code messageKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + Objects.hashCode(startEventId);
    h += (h << 5) + Objects.hashCode(messageName);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(correlationKey);
    h += (h << 5) + Long.hashCode(messageKey);
    return h;
  }

  /**
   * Prints the immutable value {@code MessageStartEventSubscriptionRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessageStartEventSubscriptionRecordValue{"
        + "variables=" + variables
        + ", tenantId=" + tenantId
        + ", processDefinitionKey=" + processDefinitionKey
        + ", bpmnProcessId=" + bpmnProcessId
        + ", startEventId=" + startEventId
        + ", messageName=" + messageName
        + ", processInstanceKey=" + processInstanceKey
        + ", correlationKey=" + correlationKey
        + ", messageKey=" + messageKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MessageStartEventSubscriptionRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageStartEventSubscriptionRecordValue instance
   */
  public static ImmutableMessageStartEventSubscriptionRecordValue copyOf(MessageStartEventSubscriptionRecordValue instance) {
    if (instance instanceof ImmutableMessageStartEventSubscriptionRecordValue) {
      return (ImmutableMessageStartEventSubscriptionRecordValue) instance;
    }
    return ImmutableMessageStartEventSubscriptionRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMessageStartEventSubscriptionRecordValue ImmutableMessageStartEventSubscriptionRecordValue}.
   * <pre>
   * ImmutableMessageStartEventSubscriptionRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link MessageStartEventSubscriptionRecordValue#getVariables() variables} mappings
   *    .withTenantId(String | null) // nullable {@link MessageStartEventSubscriptionRecordValue#getTenantId() tenantId}
   *    .withProcessDefinitionKey(long) // optional {@link MessageStartEventSubscriptionRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withBpmnProcessId(String | null) // nullable {@link MessageStartEventSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withStartEventId(String | null) // nullable {@link MessageStartEventSubscriptionRecordValue#getStartEventId() startEventId}
   *    .withMessageName(String | null) // nullable {@link MessageStartEventSubscriptionRecordValue#getMessageName() messageName}
   *    .withProcessInstanceKey(long) // optional {@link MessageStartEventSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withCorrelationKey(String | null) // nullable {@link MessageStartEventSubscriptionRecordValue#getCorrelationKey() correlationKey}
   *    .withMessageKey(long) // optional {@link MessageStartEventSubscriptionRecordValue#getMessageKey() messageKey}
   *    .build();
   * </pre>
   * @return A new ImmutableMessageStartEventSubscriptionRecordValue builder
   */
  public static ImmutableMessageStartEventSubscriptionRecordValue.Builder builder() {
    return new ImmutableMessageStartEventSubscriptionRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMessageStartEventSubscriptionRecordValue ImmutableMessageStartEventSubscriptionRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MessageStartEventSubscriptionRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private String tenantId;
    private long processDefinitionKey;
    private String bpmnProcessId;
    private String startEventId;
    private String messageName;
    private long processInstanceKey;
    private String correlationKey;
    private long messageKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageStartEventSubscriptionRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof MessageStartEventSubscriptionRecordValue) {
        MessageStartEventSubscriptionRecordValue instance = (MessageStartEventSubscriptionRecordValue) object;
        String messageNameValue = instance.getMessageName();
        if (messageNameValue != null) {
          withMessageName(messageNameValue);
        }
        withProcessInstanceKey(instance.getProcessInstanceKey());
        withMessageKey(instance.getMessageKey());
        if ((bits & 0x1L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x1L;
        }
        String startEventIdValue = instance.getStartEventId();
        if (startEventIdValue != null) {
          withStartEventId(startEventIdValue);
        }
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        String correlationKeyValue = instance.getCorrelationKey();
        if (correlationKeyValue != null) {
          withCorrelationKey(correlationKeyValue);
        }
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x1L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Put one entry to the {@link MessageStartEventSubscriptionRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(String key, Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link MessageStartEventSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MessageStartEventSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MessageStartEventSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MessageStartEventSubscriptionRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageStartEventSubscriptionRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageStartEventSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageStartEventSubscriptionRecordValue#getStartEventId() startEventId} attribute.
     * @param startEventId The value for startEventId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withStartEventId(String startEventId) {
      this.startEventId = startEventId;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageStartEventSubscriptionRecordValue#getMessageName() messageName} attribute.
     * @param messageName The value for messageName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMessageName(String messageName) {
      this.messageName = messageName;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageStartEventSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageStartEventSubscriptionRecordValue#getCorrelationKey() correlationKey} attribute.
     * @param correlationKey The value for correlationKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCorrelationKey(String correlationKey) {
      this.correlationKey = correlationKey;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageStartEventSubscriptionRecordValue#getMessageKey() messageKey} attribute.
     * @param messageKey The value for messageKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMessageKey(long messageKey) {
      this.messageKey = messageKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.tenantId = null;
      this.processDefinitionKey = 0;
      this.bpmnProcessId = null;
      this.startEventId = null;
      this.messageName = null;
      this.processInstanceKey = 0;
      this.correlationKey = null;
      this.messageKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMessageStartEventSubscriptionRecordValue ImmutableMessageStartEventSubscriptionRecordValue}.
     * @return An immutable instance of MessageStartEventSubscriptionRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMessageStartEventSubscriptionRecordValue build() {
      return new ImmutableMessageStartEventSubscriptionRecordValue(
          createUnmodifiableMap(false, false, variables),
          tenantId,
          processDefinitionKey,
          bpmnProcessId,
          startEventId,
          messageName,
          processInstanceKey,
          correlationKey,
          messageKey);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
