package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UserTaskRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUserTaskRecordValue.builder()}.
 */
@Generated(from = "UserTaskRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableUserTaskRecordValue.Builder.class)
public final class ImmutableUserTaskRecordValue
    implements UserTaskRecordValue {
  private final Map<String, Object> variables;
  private final long processInstanceKey;
  private final String tenantId;
  private final long userTaskKey;
  private final String assignee;
  private final String candidateGroups;
  private final String candidateUsers;
  private final String dueDate;
  private final String followUpDate;
  private final long formKey;
  private final String elementId;
  private final long elementInstanceKey;
  private final String bpmnProcessId;
  private final int processDefinitionVersion;
  private final long processDefinitionKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableUserTaskRecordValue(
      Map<String, Object> variables,
      long processInstanceKey,
      String tenantId,
      long userTaskKey,
      String assignee,
      String candidateGroups,
      String candidateUsers,
      String dueDate,
      String followUpDate,
      long formKey,
      String elementId,
      long elementInstanceKey,
      String bpmnProcessId,
      int processDefinitionVersion,
      long processDefinitionKey) {
    this.variables = variables;
    this.processInstanceKey = processInstanceKey;
    this.tenantId = tenantId;
    this.userTaskKey = userTaskKey;
    this.assignee = assignee;
    this.candidateGroups = candidateGroups;
    this.candidateUsers = candidateUsers;
    this.dueDate = dueDate;
    this.followUpDate = followUpDate;
    this.formKey = formKey;
    this.elementId = elementId;
    this.elementInstanceKey = elementInstanceKey;
    this.bpmnProcessId = bpmnProcessId;
    this.processDefinitionVersion = processDefinitionVersion;
    this.processDefinitionKey = processDefinitionKey;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   * @return the key of the corresponding process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return The value of the {@code userTaskKey} attribute
   */
  @Override
  public long getUserTaskKey() {
    return userTaskKey;
  }

  /**
   * @return The value of the {@code assignee} attribute
   */
  @Override
  public String getAssignee() {
    return assignee;
  }

  /**
   * @return The value of the {@code candidateGroups} attribute
   */
  @Override
  public String getCandidateGroups() {
    return candidateGroups;
  }

  /**
   * @return The value of the {@code candidateUsers} attribute
   */
  @Override
  public String getCandidateUsers() {
    return candidateUsers;
  }

  /**
   * @return The value of the {@code dueDate} attribute
   */
  @Override
  public String getDueDate() {
    return dueDate;
  }

  /**
   * @return The value of the {@code followUpDate} attribute
   */
  @Override
  public String getFollowUpDate() {
    return followUpDate;
  }

  /**
   * @return The value of the {@code formKey} attribute
   */
  @Override
  public long getFormKey() {
    return formKey;
  }

  /**
   * @return the element id of the corresponding user task
   */
  @Override
  public String getElementId() {
    return elementId;
  }

  /**
   * @return the element instance key of the corresponding user task
   */
  @Override
  public long getElementInstanceKey() {
    return elementInstanceKey;
  }

  /**
   * @return the bpmn process id of the corresponding process definition
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the version of the corresponding process definition
   */
  @Override
  public int getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  /**
   * @return the process key of the corresponding process definition
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * Copy the current immutable object by replacing the {@link UserTaskRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserTaskRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableUserTaskRecordValue(
        newValue,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        value,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        value,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getUserTaskKey() userTaskKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userTaskKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withUserTaskKey(long value) {
    if (this.userTaskKey == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        value,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getAssignee() assignee} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for assignee (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withAssignee(String value) {
    if (Objects.equals(this.assignee, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        value,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getCandidateGroups() candidateGroups} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for candidateGroups (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withCandidateGroups(String value) {
    if (Objects.equals(this.candidateGroups, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        value,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getCandidateUsers() candidateUsers} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for candidateUsers (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withCandidateUsers(String value) {
    if (Objects.equals(this.candidateUsers, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        value,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getDueDate() dueDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dueDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withDueDate(String value) {
    if (Objects.equals(this.dueDate, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        value,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getFollowUpDate() followUpDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for followUpDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withFollowUpDate(String value) {
    if (Objects.equals(this.followUpDate, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        value,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getFormKey() formKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withFormKey(long value) {
    if (this.formKey == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        value,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getElementId() elementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withElementId(String value) {
    if (Objects.equals(this.elementId, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        value,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withElementInstanceKey(long value) {
    if (this.elementInstanceKey == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        value,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        value,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getProcessDefinitionVersion() processDefinitionVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withProcessDefinitionVersion(int value) {
    if (this.processDefinitionVersion == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        value,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserTaskRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserTaskRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableUserTaskRecordValue(
        this.variables,
        this.processInstanceKey,
        this.tenantId,
        this.userTaskKey,
        this.assignee,
        this.candidateGroups,
        this.candidateUsers,
        this.dueDate,
        this.followUpDate,
        this.formKey,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUserTaskRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUserTaskRecordValue
        && equalTo(0, (ImmutableUserTaskRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableUserTaskRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && processInstanceKey == another.processInstanceKey
        && Objects.equals(tenantId, another.tenantId)
        && userTaskKey == another.userTaskKey
        && Objects.equals(assignee, another.assignee)
        && Objects.equals(candidateGroups, another.candidateGroups)
        && Objects.equals(candidateUsers, another.candidateUsers)
        && Objects.equals(dueDate, another.dueDate)
        && Objects.equals(followUpDate, another.followUpDate)
        && formKey == another.formKey
        && Objects.equals(elementId, another.elementId)
        && elementInstanceKey == another.elementInstanceKey
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && processDefinitionVersion == another.processDefinitionVersion
        && processDefinitionKey == another.processDefinitionKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code processInstanceKey}, {@code tenantId}, {@code userTaskKey}, {@code assignee}, {@code candidateGroups}, {@code candidateUsers}, {@code dueDate}, {@code followUpDate}, {@code formKey}, {@code elementId}, {@code elementInstanceKey}, {@code bpmnProcessId}, {@code processDefinitionVersion}, {@code processDefinitionKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(userTaskKey);
    h += (h << 5) + Objects.hashCode(assignee);
    h += (h << 5) + Objects.hashCode(candidateGroups);
    h += (h << 5) + Objects.hashCode(candidateUsers);
    h += (h << 5) + Objects.hashCode(dueDate);
    h += (h << 5) + Objects.hashCode(followUpDate);
    h += (h << 5) + Long.hashCode(formKey);
    h += (h << 5) + Objects.hashCode(elementId);
    h += (h << 5) + Long.hashCode(elementInstanceKey);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + processDefinitionVersion;
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    return h;
  }

  /**
   * Prints the immutable value {@code UserTaskRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserTaskRecordValue{"
        + "variables=" + variables
        + ", processInstanceKey=" + processInstanceKey
        + ", tenantId=" + tenantId
        + ", userTaskKey=" + userTaskKey
        + ", assignee=" + assignee
        + ", candidateGroups=" + candidateGroups
        + ", candidateUsers=" + candidateUsers
        + ", dueDate=" + dueDate
        + ", followUpDate=" + followUpDate
        + ", formKey=" + formKey
        + ", elementId=" + elementId
        + ", elementInstanceKey=" + elementInstanceKey
        + ", bpmnProcessId=" + bpmnProcessId
        + ", processDefinitionVersion=" + processDefinitionVersion
        + ", processDefinitionKey=" + processDefinitionKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link UserTaskRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UserTaskRecordValue instance
   */
  public static ImmutableUserTaskRecordValue copyOf(UserTaskRecordValue instance) {
    if (instance instanceof ImmutableUserTaskRecordValue) {
      return (ImmutableUserTaskRecordValue) instance;
    }
    return ImmutableUserTaskRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUserTaskRecordValue ImmutableUserTaskRecordValue}.
   * <pre>
   * ImmutableUserTaskRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link UserTaskRecordValue#getVariables() variables} mappings
   *    .withProcessInstanceKey(long) // optional {@link UserTaskRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withTenantId(String | null) // nullable {@link UserTaskRecordValue#getTenantId() tenantId}
   *    .withUserTaskKey(long) // optional {@link UserTaskRecordValue#getUserTaskKey() userTaskKey}
   *    .withAssignee(String | null) // nullable {@link UserTaskRecordValue#getAssignee() assignee}
   *    .withCandidateGroups(String | null) // nullable {@link UserTaskRecordValue#getCandidateGroups() candidateGroups}
   *    .withCandidateUsers(String | null) // nullable {@link UserTaskRecordValue#getCandidateUsers() candidateUsers}
   *    .withDueDate(String | null) // nullable {@link UserTaskRecordValue#getDueDate() dueDate}
   *    .withFollowUpDate(String | null) // nullable {@link UserTaskRecordValue#getFollowUpDate() followUpDate}
   *    .withFormKey(long) // optional {@link UserTaskRecordValue#getFormKey() formKey}
   *    .withElementId(String | null) // nullable {@link UserTaskRecordValue#getElementId() elementId}
   *    .withElementInstanceKey(long) // optional {@link UserTaskRecordValue#getElementInstanceKey() elementInstanceKey}
   *    .withBpmnProcessId(String | null) // nullable {@link UserTaskRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withProcessDefinitionVersion(int) // optional {@link UserTaskRecordValue#getProcessDefinitionVersion() processDefinitionVersion}
   *    .withProcessDefinitionKey(long) // optional {@link UserTaskRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .build();
   * </pre>
   * @return A new ImmutableUserTaskRecordValue builder
   */
  public static ImmutableUserTaskRecordValue.Builder builder() {
    return new ImmutableUserTaskRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUserTaskRecordValue ImmutableUserTaskRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UserTaskRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private long processInstanceKey;
    private String tenantId;
    private long userTaskKey;
    private String assignee;
    private String candidateGroups;
    private String candidateUsers;
    private String dueDate;
    private String followUpDate;
    private long formKey;
    private String elementId;
    private long elementInstanceKey;
    private String bpmnProcessId;
    private int processDefinitionVersion;
    private long processDefinitionKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.UserTaskRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserTaskRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof UserTaskRecordValue) {
        UserTaskRecordValue instance = (UserTaskRecordValue) object;
        String elementIdValue = instance.getElementId();
        if (elementIdValue != null) {
          withElementId(elementIdValue);
        }
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
        withFormKey(instance.getFormKey());
        String dueDateValue = instance.getDueDate();
        if (dueDateValue != null) {
          withDueDate(dueDateValue);
        }
        withUserTaskKey(instance.getUserTaskKey());
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
        String followUpDateValue = instance.getFollowUpDate();
        if (followUpDateValue != null) {
          withFollowUpDate(followUpDateValue);
        }
        withElementInstanceKey(instance.getElementInstanceKey());
        String candidateGroupsValue = instance.getCandidateGroups();
        if (candidateGroupsValue != null) {
          withCandidateGroups(candidateGroupsValue);
        }
        String candidateUsersValue = instance.getCandidateUsers();
        if (candidateUsersValue != null) {
          withCandidateUsers(candidateUsersValue);
        }
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
        String assigneeValue = instance.getAssignee();
        if (assigneeValue != null) {
          withAssignee(assigneeValue);
        }
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        withProcessDefinitionVersion(instance.getProcessDefinitionVersion());
      }
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Put one entry to the {@link UserTaskRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(String key, Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UserTaskRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UserTaskRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UserTaskRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getUserTaskKey() userTaskKey} attribute.
     * @param userTaskKey The value for userTaskKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withUserTaskKey(long userTaskKey) {
      this.userTaskKey = userTaskKey;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getAssignee() assignee} attribute.
     * @param assignee The value for assignee (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withAssignee(String assignee) {
      this.assignee = assignee;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getCandidateGroups() candidateGroups} attribute.
     * @param candidateGroups The value for candidateGroups (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCandidateGroups(String candidateGroups) {
      this.candidateGroups = candidateGroups;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getCandidateUsers() candidateUsers} attribute.
     * @param candidateUsers The value for candidateUsers (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCandidateUsers(String candidateUsers) {
      this.candidateUsers = candidateUsers;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getDueDate() dueDate} attribute.
     * @param dueDate The value for dueDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDueDate(String dueDate) {
      this.dueDate = dueDate;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getFollowUpDate() followUpDate} attribute.
     * @param followUpDate The value for followUpDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withFollowUpDate(String followUpDate) {
      this.followUpDate = followUpDate;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getFormKey() formKey} attribute.
     * @param formKey The value for formKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withFormKey(long formKey) {
      this.formKey = formKey;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getElementId() elementId} attribute.
     * @param elementId The value for elementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementId(String elementId) {
      this.elementId = elementId;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
     * @param elementInstanceKey The value for elementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementInstanceKey(long elementInstanceKey) {
      this.elementInstanceKey = elementInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getProcessDefinitionVersion() processDefinitionVersion} attribute.
     * @param processDefinitionVersion The value for processDefinitionVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionVersion(int processDefinitionVersion) {
      this.processDefinitionVersion = processDefinitionVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link UserTaskRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.processInstanceKey = 0;
      this.tenantId = null;
      this.userTaskKey = 0;
      this.assignee = null;
      this.candidateGroups = null;
      this.candidateUsers = null;
      this.dueDate = null;
      this.followUpDate = null;
      this.formKey = 0;
      this.elementId = null;
      this.elementInstanceKey = 0;
      this.bpmnProcessId = null;
      this.processDefinitionVersion = 0;
      this.processDefinitionKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUserTaskRecordValue ImmutableUserTaskRecordValue}.
     * @return An immutable instance of UserTaskRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUserTaskRecordValue build() {
      return new ImmutableUserTaskRecordValue(
          createUnmodifiableMap(false, false, variables),
          processInstanceKey,
          tenantId,
          userTaskKey,
          assignee,
          candidateGroups,
          candidateUsers,
          dueDate,
          followUpDate,
          formKey,
          elementId,
          elementInstanceKey,
          bpmnProcessId,
          processDefinitionVersion,
          processDefinitionKey);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
