/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.intent;

import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;

public enum UserTaskIntent implements ProcessInstanceRelatedIntent
{
    CREATING(0),
    CREATED(1),
    COMPLETE(2, false),
    COMPLETING(3),
    COMPLETED(4),
    CANCELING(5),
    CANCELED(6),
    ASSIGN(7),
    ASSIGNING(8),
    ASSIGNED(9),
    CLAIM(10);

    private final short value;
    private final boolean shouldBanInstance;

    private UserTaskIntent(int value) {
        this(value, true);
    }

    private UserTaskIntent(int value, boolean shouldBanInstance) {
        this.value = (short)value;
        this.shouldBanInstance = shouldBanInstance;
    }

    public short getIntent() {
        return this.value;
    }

    public static Intent from(short value) {
        switch (value) {
            case 0: {
                return CREATING;
            }
            case 1: {
                return CREATED;
            }
            case 2: {
                return COMPLETE;
            }
            case 3: {
                return COMPLETING;
            }
            case 4: {
                return COMPLETED;
            }
            case 5: {
                return CANCELING;
            }
            case 6: {
                return CANCELED;
            }
            case 7: {
                return ASSIGN;
            }
            case 8: {
                return ASSIGNING;
            }
            case 9: {
                return ASSIGNED;
            }
            case 10: {
                return CLAIM;
            }
        }
        return UNKNOWN;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean shouldBanInstanceOnError() {
        return this.shouldBanInstance;
    }
}

