package io.camunda.zeebe.protocol.record;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Record}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRecord.builder()}.
 */
@Generated(from = "Record", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableRecord.Builder.class)
public final class ImmutableRecord<T extends RecordValue>
    implements Record<T> {
  private final long position;
  private final long sourceRecordPosition;
  private final long key;
  private final long timestamp;
  private final Intent intent;
  private final int partitionId;
  private final RecordType recordType;
  private final RejectionType rejectionType;
  private final String rejectionReason;
  private final String brokerVersion;
  private final Map<String, Object> authorizations;
  private final int recordVersion;
  private final ValueType valueType;
  private final T value;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableRecord(
      long position,
      long sourceRecordPosition,
      long key,
      long timestamp,
      Intent intent,
      int partitionId,
      RecordType recordType,
      RejectionType rejectionType,
      String rejectionReason,
      String brokerVersion,
      Map<String, Object> authorizations,
      int recordVersion,
      ValueType valueType,
      T value) {
    this.position = position;
    this.sourceRecordPosition = sourceRecordPosition;
    this.key = key;
    this.timestamp = timestamp;
    this.intent = intent;
    this.partitionId = partitionId;
    this.recordType = recordType;
    this.rejectionType = rejectionType;
    this.rejectionReason = rejectionReason;
    this.brokerVersion = brokerVersion;
    this.authorizations = authorizations;
    this.recordVersion = recordVersion;
    this.valueType = valueType;
    this.value = value;
  }

  /**
   * Retrieves the position of the record. Positions are locally unique to the partition, and
   * monotonically increasing. Records are then ordered on the partition by their positions, i.e.
   * lower position means the record was published earlier.
   * @return position the record
   */
  @Override
  public long getPosition() {
    return position;
  }

  /**
   * Returns the position of the source record. The source record denotes the record which caused
   * the current record. It can be unset (meaning there is no source record), at which point the
   * position returned here will be -1. Anything >= 0 implies a source record.
   * @return position of the source record
   */
  @Override
  public long getSourceRecordPosition() {
    return sourceRecordPosition;
  }

  /**
   * Retrieves the key of the record.
   * <p>Multiple records can have the same key if they belongs to the same logical entity. Keys are
   * unique for the combination of partition and record type.
   * @return the key of the record
   */
  @Override
  public long getKey() {
    return key;
  }

  /**
   * @return the unix timestamp at which the record was published on the partition.
   */
  @Override
  public long getTimestamp() {
    return timestamp;
  }

  /**
   * @return the intent of the record
   */
  @Override
  public Intent getIntent() {
    return intent;
  }

  /**
   * @return the partition ID on which the record was published
   */
  @Override
  public int getPartitionId() {
    return partitionId;
  }

  /**
   * @return the type of the record (event, command or command rejection)
   */
  @Override
  public RecordType getRecordType() {
    return recordType;
  }

  /**
   * @return the type of rejection if {@link #getRecordType()} returns {@link
   *     RecordType#COMMAND_REJECTION} or else <code>null</code>.
   */
  @Override
  public RejectionType getRejectionType() {
    return rejectionType;
  }

  /**
   * @return the reason why a command was rejected if {@link #getRecordType()} returns {@link
   *     RecordType#COMMAND_REJECTION} or else <code>null</code>.
   */
  @Override
  public String getRejectionReason() {
    return rejectionReason;
  }

  /**
   * @return the version of the broker that wrote this record
   */
  @Override
  public String getBrokerVersion() {
    return brokerVersion;
  }

  /**
   * Provides the authorization data of the user the triggered the creation of this record. The
   * following entries may be available:
   * <ul>
   *   <li>Key: <code>authorized_tenants</code>; Value: a List of Strings defining the user's
   *       authorized tenants.
   * </ul>
   * @return a Map of authorization data for this record or an empty Map if not set.
   */
  @Override
  public Map<String, Object> getAuthorizations() {
    return authorizations;
  }

  /**
   * A record version is an integer starting from 1. The version of a record is defined when it is
   * written. It allows different versions of the same record to be processed or applied
   * differently.
   * <p>For example, it allows us to apply an older event in the same way as when it was originally
   * written, while allowing newer events to be applied differently.
   * @return the version of the record when written
   */
  @Override
  public int getRecordVersion() {
    return recordVersion;
  }

  /**
   * @return the type of the record (e.g. job, process, process instance, etc.)
   */
  @Override
  public ValueType getValueType() {
    return valueType;
  }

  /**
   * Returns the raw value of the record, which should implement one of the interfaces in the {@link
   * io.camunda.zeebe.protocol.record.value} package.
   * <p>The record value is essentially the record specific data, e.g. for a process instance
   * creation event, it would contain information relevant to the process instance being created.
   * @return record value
   */
  @Override
  public T getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getPosition() position} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for position
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withPosition(long value) {
    if (this.position == value) return this;
    return new ImmutableRecord<>(
        value,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        this.intent,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getSourceRecordPosition() sourceRecordPosition} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sourceRecordPosition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withSourceRecordPosition(long value) {
    if (this.sourceRecordPosition == value) return this;
    return new ImmutableRecord<>(
        this.position,
        value,
        this.key,
        this.timestamp,
        this.intent,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getKey() key} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withKey(long value) {
    if (this.key == value) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        value,
        this.timestamp,
        this.intent,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getTimestamp() timestamp} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timestamp
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withTimestamp(long value) {
    if (this.timestamp == value) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        value,
        this.intent,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getIntent() intent} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for intent (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withIntent(Intent value) {
    if (this.intent == value) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        value,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getPartitionId() partitionId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for partitionId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withPartitionId(int value) {
    if (this.partitionId == value) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        this.intent,
        value,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getRecordType() recordType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for recordType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withRecordType(RecordType value) {
    if (this.recordType == value) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        this.intent,
        this.partitionId,
        value,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getRejectionType() rejectionType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rejectionType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withRejectionType(RejectionType value) {
    if (this.rejectionType == value) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        this.intent,
        this.partitionId,
        this.recordType,
        value,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getRejectionReason() rejectionReason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rejectionReason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withRejectionReason(String value) {
    if (Objects.equals(this.rejectionReason, value)) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        this.intent,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        value,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getBrokerVersion() brokerVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for brokerVersion (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withBrokerVersion(String value) {
    if (Objects.equals(this.brokerVersion, value)) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        this.intent,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        value,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by replacing the {@link Record#getAuthorizations() authorizations} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the authorizations map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRecord<T> withAuthorizations(Map<String, ? extends Object> entries) {
    if (this.authorizations == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        this.intent,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        newValue,
        this.recordVersion,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getRecordVersion() recordVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for recordVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withRecordVersion(int value) {
    if (this.recordVersion == value) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        this.intent,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        value,
        this.valueType,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getValueType() valueType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withValueType(ValueType value) {
    if (this.valueType == value) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        this.intent,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        value,
        this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Record#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRecord<T> withValue(T value) {
    if (this.value == value) return this;
    return new ImmutableRecord<>(
        this.position,
        this.sourceRecordPosition,
        this.key,
        this.timestamp,
        this.intent,
        this.partitionId,
        this.recordType,
        this.rejectionType,
        this.rejectionReason,
        this.brokerVersion,
        this.authorizations,
        this.recordVersion,
        this.valueType,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRecord} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRecord<?>
        && equalTo(0, (ImmutableRecord<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableRecord<?> another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return position == another.position
        && sourceRecordPosition == another.sourceRecordPosition
        && key == another.key
        && timestamp == another.timestamp
        && Objects.equals(intent, another.intent)
        && partitionId == another.partitionId
        && Objects.equals(recordType, another.recordType)
        && Objects.equals(rejectionType, another.rejectionType)
        && Objects.equals(rejectionReason, another.rejectionReason)
        && Objects.equals(brokerVersion, another.brokerVersion)
        && authorizations.equals(another.authorizations)
        && recordVersion == another.recordVersion
        && Objects.equals(valueType, another.valueType)
        && Objects.equals(value, another.value);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code position}, {@code sourceRecordPosition}, {@code key}, {@code timestamp}, {@code intent}, {@code partitionId}, {@code recordType}, {@code rejectionType}, {@code rejectionReason}, {@code brokerVersion}, {@code authorizations}, {@code recordVersion}, {@code valueType}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(position);
    h += (h << 5) + Long.hashCode(sourceRecordPosition);
    h += (h << 5) + Long.hashCode(key);
    h += (h << 5) + Long.hashCode(timestamp);
    h += (h << 5) + Objects.hashCode(intent);
    h += (h << 5) + partitionId;
    h += (h << 5) + Objects.hashCode(recordType);
    h += (h << 5) + Objects.hashCode(rejectionType);
    h += (h << 5) + Objects.hashCode(rejectionReason);
    h += (h << 5) + Objects.hashCode(brokerVersion);
    h += (h << 5) + authorizations.hashCode();
    h += (h << 5) + recordVersion;
    h += (h << 5) + Objects.hashCode(valueType);
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code Record} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Record{"
        + "position=" + position
        + ", sourceRecordPosition=" + sourceRecordPosition
        + ", key=" + key
        + ", timestamp=" + timestamp
        + ", intent=" + intent
        + ", partitionId=" + partitionId
        + ", recordType=" + recordType
        + ", rejectionType=" + rejectionType
        + ", rejectionReason=" + rejectionReason
        + ", brokerVersion=" + brokerVersion
        + ", authorizations=" + authorizations
        + ", recordVersion=" + recordVersion
        + ", valueType=" + valueType
        + ", value=" + value
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Record} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Record instance
   */
  public static <T extends RecordValue> ImmutableRecord<T> copyOf(Record<T> instance) {
    if (instance instanceof ImmutableRecord<?>) {
      return (ImmutableRecord<T>) instance;
    }
    return ImmutableRecord.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRecord ImmutableRecord}.
   * <pre>
   * ImmutableRecord.&amp;lt;T&amp;gt;builder()
   *    .withPosition(long) // optional {@link Record#getPosition() position}
   *    .withSourceRecordPosition(long) // optional {@link Record#getSourceRecordPosition() sourceRecordPosition}
   *    .withKey(long) // optional {@link Record#getKey() key}
   *    .withTimestamp(long) // optional {@link Record#getTimestamp() timestamp}
   *    .withIntent(io.camunda.zeebe.protocol.record.intent.Intent | null) // nullable {@link Record#getIntent() intent}
   *    .withPartitionId(int) // optional {@link Record#getPartitionId() partitionId}
   *    .withRecordType(io.camunda.zeebe.protocol.record.RecordType | null) // nullable {@link Record#getRecordType() recordType}
   *    .withRejectionType(io.camunda.zeebe.protocol.record.RejectionType | null) // nullable {@link Record#getRejectionType() rejectionType}
   *    .withRejectionReason(String | null) // nullable {@link Record#getRejectionReason() rejectionReason}
   *    .withBrokerVersion(String | null) // nullable {@link Record#getBrokerVersion() brokerVersion}
   *    .putAuthorization|putAllAuthorizations(String =&gt; Object) // {@link Record#getAuthorizations() authorizations} mappings
   *    .withRecordVersion(int) // optional {@link Record#getRecordVersion() recordVersion}
   *    .withValueType(io.camunda.zeebe.protocol.record.ValueType | null) // nullable {@link Record#getValueType() valueType}
   *    .withValue(T | null) // nullable {@link Record#getValue() value}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableRecord builder
   */
  public static <T extends RecordValue> ImmutableRecord.Builder<T> builder() {
    return new ImmutableRecord.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableRecord ImmutableRecord}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Record", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder<T extends RecordValue> {
    private long position;
    private long sourceRecordPosition;
    private long key;
    private long timestamp;
    private Intent intent;
    private int partitionId;
    private RecordType recordType;
    private RejectionType rejectionType;
    private String rejectionReason;
    private String brokerVersion;
    private Map<String, Object> authorizations = new LinkedHashMap<String, Object>();
    private int recordVersion;
    private ValueType valueType;
    private T value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Record} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(Record<T> instance) {
      Objects.requireNonNull(instance, "instance");
      this.withPosition(instance.getPosition());
      this.withSourceRecordPosition(instance.getSourceRecordPosition());
      this.withKey(instance.getKey());
      this.withTimestamp(instance.getTimestamp());
      Intent intentValue = instance.getIntent();
      if (intentValue != null) {
        withIntent(intentValue);
      }
      this.withPartitionId(instance.getPartitionId());
      RecordType recordTypeValue = instance.getRecordType();
      if (recordTypeValue != null) {
        withRecordType(recordTypeValue);
      }
      RejectionType rejectionTypeValue = instance.getRejectionType();
      if (rejectionTypeValue != null) {
        withRejectionType(rejectionTypeValue);
      }
      String rejectionReasonValue = instance.getRejectionReason();
      if (rejectionReasonValue != null) {
        withRejectionReason(rejectionReasonValue);
      }
      String brokerVersionValue = instance.getBrokerVersion();
      if (brokerVersionValue != null) {
        withBrokerVersion(brokerVersionValue);
      }
      putAllAuthorizations(instance.getAuthorizations());
      this.withRecordVersion(instance.getRecordVersion());
      ValueType valueTypeValue = instance.getValueType();
      if (valueTypeValue != null) {
        withValueType(valueTypeValue);
      }
      T valueValue = instance.getValue();
      if (valueValue != null) {
        withValue(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getPosition() position} attribute.
     * @param position The value for position 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withPosition(long position) {
      this.position = position;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getSourceRecordPosition() sourceRecordPosition} attribute.
     * @param sourceRecordPosition The value for sourceRecordPosition 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withSourceRecordPosition(long sourceRecordPosition) {
      this.sourceRecordPosition = sourceRecordPosition;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withKey(long key) {
      this.key = key;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withTimestamp(long timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getIntent() intent} attribute.
     * @param intent The value for intent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withIntent(Intent intent) {
      this.intent = intent;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getPartitionId() partitionId} attribute.
     * @param partitionId The value for partitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getRecordType() recordType} attribute.
     * @param recordType The value for recordType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withRecordType(RecordType recordType) {
      this.recordType = recordType;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getRejectionType() rejectionType} attribute.
     * @param rejectionType The value for rejectionType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withRejectionType(RejectionType rejectionType) {
      this.rejectionType = rejectionType;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getRejectionReason() rejectionReason} attribute.
     * @param rejectionReason The value for rejectionReason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withRejectionReason(String rejectionReason) {
      this.rejectionReason = rejectionReason;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getBrokerVersion() brokerVersion} attribute.
     * @param brokerVersion The value for brokerVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withBrokerVersion(String brokerVersion) {
      this.brokerVersion = brokerVersion;
      return this;
    }

    /**
     * Put one entry to the {@link Record#getAuthorizations() authorizations} map.
     * @param key The key in the authorizations map
     * @param value The associated value in the authorizations map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> putAuthorization(String key, Object value) {
      this.authorizations.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Record#getAuthorizations() authorizations} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> putAuthorization(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.authorizations.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Record#getAuthorizations() authorizations} map. Nulls are not permitted
     * @param entries The entries that will be added to the authorizations map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withAuthorizations(Map<String, ? extends Object> entries) {
      this.authorizations.clear();
      return putAllAuthorizations(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Record#getAuthorizations() authorizations} map. Nulls are not permitted
     * @param entries The entries that will be added to the authorizations map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> putAllAuthorizations(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.authorizations.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getRecordVersion() recordVersion} attribute.
     * @param recordVersion The value for recordVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withRecordVersion(int recordVersion) {
      this.recordVersion = recordVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getValueType() valueType} attribute.
     * @param valueType The value for valueType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withValueType(ValueType valueType) {
      this.valueType = valueType;
      return this;
    }

    /**
     * Initializes the value for the {@link Record#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> withValue(T value) {
      this.value = value;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder<T> clear() {
      this.position = 0;
      this.sourceRecordPosition = 0;
      this.key = 0;
      this.timestamp = 0;
      this.intent = null;
      this.partitionId = 0;
      this.recordType = null;
      this.rejectionType = null;
      this.rejectionReason = null;
      this.brokerVersion = null;
      this.authorizations.clear();
      this.recordVersion = 0;
      this.valueType = null;
      this.value = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRecord ImmutableRecord}.
     * @return An immutable instance of Record
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRecord<T> build() {
      return new ImmutableRecord<>(
          position,
          sourceRecordPosition,
          key,
          timestamp,
          intent,
          partitionId,
          recordType,
          rejectionType,
          rejectionReason,
          brokerVersion,
          createUnmodifiableMap(false, false, authorizations),
          recordVersion,
          valueType,
          value);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
