/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.AsyncClosable;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.ScheduledTimer;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.util.Loggers;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class Actor
implements AutoCloseable,
AsyncClosable,
ConcurrencyControl {
    public static final String ACTOR_PROP_NAME = "actor-name";
    public static final String ACTOR_PROP_PARTITION_ID = "partitionId";
    private static final int MAX_CLOSE_TIMEOUT = 300;
    protected final ActorControl actor = new ActorControl(this);
    private Map<String, String> context;

    protected Map<String, String> createContext() {
        HashMap<String, String> baseContext = new HashMap<String, String>();
        baseContext.put(ACTOR_PROP_NAME, this.getName());
        return baseContext;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Map<String, String> getContext() {
        if (this.context == null) {
            this.context = Collections.unmodifiableMap(this.createContext());
        }
        return this.context;
    }

    public boolean isActorClosed() {
        return this.actor.isClosed();
    }

    protected void onActorStarting() {
    }

    protected void onActorStarted() {
    }

    protected void onActorClosing() {
    }

    protected void onActorClosed() {
    }

    protected void onActorCloseRequested() {
    }

    public static Actor wrap(final Consumer<ActorControl> r) {
        return new Actor(){

            @Override
            public String getName() {
                return r.toString();
            }

            @Override
            protected void onActorStarted() {
                r.accept(this.actor);
            }
        };
    }

    @Override
    public void close() {
        this.closeAsync().join(300L, TimeUnit.SECONDS);
    }

    @Override
    public ActorFuture<Void> closeAsync() {
        return this.actor.close();
    }

    public static String buildActorName(String name, int partitionId) {
        return "%s-%d".formatted(name, partitionId);
    }

    protected void handleFailure(Throwable failure) {
        Loggers.ACTOR_LOGGER.error("Uncaught exception in '{}' in phase '{}'. Continuing with next job.", new Object[]{this.getName(), this.actor.getLifecyclePhase(), failure});
    }

    public void onActorFailed() {
    }

    @Override
    public <T> void runOnCompletion(ActorFuture<T> future, BiConsumer<T, Throwable> callback) {
        this.actor.runOnCompletion(future, callback);
    }

    @Override
    public void run(Runnable action) {
        this.actor.run(action);
    }

    @Override
    public <T> ActorFuture<T> call(Callable<T> callable) {
        return this.actor.call(callable);
    }

    @Override
    public ScheduledTimer schedule(Duration delay, Runnable runnable) {
        return this.actor.schedule(delay, runnable);
    }

    public static ActorBuilder newActor() {
        return new ActorBuilder();
    }

    public static class ActorBuilder {
        private String name;
        private Consumer<ActorControl> actorStartedHandler;

        public ActorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ActorBuilder actorStartedHandler(Consumer<ActorControl> actorStartedHandler) {
            this.actorStartedHandler = actorStartedHandler;
            return this;
        }

        public Actor build() {
            Consumer<ActorControl> wrapper = new Consumer<ActorControl>(){

                public String toString() {
                    if (name != null) {
                        return name;
                    }
                    if (actorStartedHandler != null) {
                        return actorStartedHandler.getClass().getName();
                    }
                    return super.toString();
                }

                @Override
                public void accept(ActorControl t) {
                    if (actorStartedHandler != null) {
                        actorStartedHandler.accept(t);
                    }
                }
            };
            return Actor.wrap(wrapper);
        }
    }
}

