/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.ActorJob;
import io.camunda.zeebe.scheduler.ActorTask;
import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.TimerSubscription;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.util.concurrent.TimeUnit;

public final class StampedTimerSubscription
implements TimerSubscription {
    private final ActorJob job;
    private final ActorTask task;
    private final long deadline;
    private volatile boolean isDone = false;
    private volatile boolean isCanceled = false;
    private long timerId = -1L;
    private ActorThread thread;
    private long timerExpiredAt;

    public StampedTimerSubscription(ActorJob job, long timestamp) {
        this.job = job;
        this.task = job.getTask();
        this.deadline = timestamp;
    }

    @Override
    public boolean poll() {
        return this.isDone;
    }

    @Override
    public ActorJob getJob() {
        return this.job;
    }

    @Override
    public boolean isRecurring() {
        return false;
    }

    @Override
    public void onJobCompleted() {
    }

    @Override
    public void cancel() {
        if (!this.isCanceled && !this.isDone) {
            this.task.onSubscriptionCancelled(this);
            this.isCanceled = true;
            ActorThread current = ActorThread.current();
            if (current != this.thread) {
                this.thread.submittedCallbacks.add((Object)this);
            } else {
                this.run();
            }
        }
    }

    @Override
    public long getTimerId() {
        return this.timerId;
    }

    @Override
    public void setTimerId(long timerId) {
        this.timerId = timerId;
    }

    @Override
    public void submit() {
        this.thread = ActorThread.current();
        this.thread.scheduleTimer(this);
    }

    @Override
    public long getDeadline(ActorClock ignored) {
        return this.deadline;
    }

    @Override
    public void onTimerExpired(TimeUnit timeUnit, long now) {
        if (!this.isCanceled) {
            this.isDone = true;
            this.timerExpiredAt = timeUnit.toNanos(now);
            this.task.tryWakeup();
        }
    }

    @Override
    public void run() {
        this.thread.removeTimer(this);
    }

    @Override
    public long getTimerExpiredAt() {
        return this.timerExpiredAt;
    }

    public String toString() {
        return "TimerSubscription{timerId=" + this.timerId + ", deadline=" + this.deadline + ", isDone=" + this.isDone + ", isCanceled=" + this.isCanceled + ", thread=" + String.valueOf(this.thread) + "}";
    }
}

