/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.snapshots.SnapshotChunk;
import io.camunda.zeebe.snapshots.SnapshotChunkReader;
import io.camunda.zeebe.snapshots.impl.SnapshotChunkUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class FileBasedSnapshotChunkReader
implements SnapshotChunkReader {
    static final Charset ID_CHARSET = StandardCharsets.US_ASCII;
    private final Path directory;
    private final NavigableSet<CharSequence> chunks;
    private final CharSequenceView chunkIdView;
    private NavigableSet<CharSequence> chunksView;
    private final int totalCount;
    private final long snapshotChecksum;
    private final String snapshotID;

    FileBasedSnapshotChunkReader(Path directory, long checksum) throws IOException {
        this.directory = directory;
        this.chunks = this.collectChunks(directory);
        this.totalCount = this.chunks.size();
        this.chunksView = new TreeSet<CharSequence>((SortedSet<CharSequence>)this.chunks);
        this.chunkIdView = new CharSequenceView();
        this.snapshotChecksum = checksum;
        this.snapshotID = directory.getFileName().toString();
    }

    private NavigableSet<CharSequence> collectChunks(Path directory) throws IOException {
        TreeSet<CharSequence> set = new TreeSet<CharSequence>(CharSequence::compare);
        try (Stream<Path> stream = Files.list(directory).sorted();){
            stream.map(directory::relativize).map(Path::toString).forEach(set::add);
        }
        return set;
    }

    @Override
    public void reset() {
        this.chunksView = new TreeSet<CharSequence>((SortedSet<CharSequence>)this.chunks);
    }

    @Override
    public void seek(ByteBuffer id) {
        if (id == null) {
            return;
        }
        CharSequence path = this.decodeChunkId(id);
        this.chunksView = new TreeSet<CharSequence>((SortedSet<CharSequence>)this.chunks.tailSet(path, true));
    }

    @Override
    public ByteBuffer nextId() {
        if (this.chunksView.isEmpty()) {
            return null;
        }
        return this.encodeChunkId((CharSequence)this.chunksView.first());
    }

    public void close() {
        this.chunks.clear();
        this.chunksView.clear();
    }

    @Override
    public boolean hasNext() {
        return !this.chunksView.isEmpty();
    }

    @Override
    public SnapshotChunk next() {
        CharSequence chunkName = this.chunksView.pollFirst();
        if (chunkName == null) {
            throw new NoSuchElementException();
        }
        Path path = this.directory.resolve(chunkName.toString());
        try {
            return SnapshotChunkUtil.createSnapshotChunkFromFile(path, this.snapshotID, this.totalCount, this.snapshotChecksum);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ByteBuffer encodeChunkId(CharSequence path) {
        return ByteBuffer.wrap(path.toString().getBytes(ID_CHARSET)).order(Protocol.ENDIANNESS);
    }

    private CharSequence decodeChunkId(ByteBuffer id) {
        return this.chunkIdView.wrap(id);
    }

    private static final class CharSequenceView {
        private final DirectBuffer wrapper = new UnsafeBuffer();
        private final AsciiSequenceView view = new AsciiSequenceView();

        private CharSequenceView() {
        }

        private CharSequence wrap(ByteBuffer buffer) {
            this.wrapper.wrap(buffer);
            return this.view.wrap(this.wrapper, 0, this.wrapper.capacity());
        }
    }
}

