/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.util.exception.UnrecoverableException;
import java.nio.file.Path;

public final class InvalidSnapshotChecksum
extends UnrecoverableException {
    private static final String MESSAGE_FORMAT = "Expected snapshot %s to have checksum %d, but was %d";
    private final transient Path snapshotPath;
    private final long expectedChecksum;
    private final long actualChecksum;

    public InvalidSnapshotChecksum(Path snapshotPath, long expectedChecksum, long actualChecksum) {
        super(String.format(MESSAGE_FORMAT, snapshotPath, expectedChecksum, actualChecksum));
        this.snapshotPath = snapshotPath;
        this.expectedChecksum = expectedChecksum;
        this.actualChecksum = actualChecksum;
    }

    public InvalidSnapshotChecksum(Throwable cause, Path snapshotPath, long expectedChecksum, long actualChecksum) {
        super(String.format(MESSAGE_FORMAT, snapshotPath, expectedChecksum, actualChecksum), cause);
        this.snapshotPath = snapshotPath;
        this.expectedChecksum = expectedChecksum;
        this.actualChecksum = actualChecksum;
    }

    public Path getSnapshotPath() {
        return this.snapshotPath;
    }

    public long getExpectedChecksum() {
        return this.expectedChecksum;
    }

    public long getActualChecksum() {
        return this.actualChecksum;
    }
}

