/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.SnapshotChunk;
import io.camunda.zeebe.snapshots.SnapshotChunkReader;
import io.camunda.zeebe.snapshots.impl.SnapshotChunkId;
import io.camunda.zeebe.snapshots.impl.SnapshotChunkUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;

public final class FileBasedSnapshotChunkReader
implements SnapshotChunkReader {
    private final Path directory;
    private final NavigableSet<CharSequence> chunks;
    private long offset;
    private NavigableSet<CharSequence> chunksView;
    private final int totalCount;
    private final String snapshotID;
    private long maximumChunkSize;

    public FileBasedSnapshotChunkReader(Path directory) throws IOException {
        this(directory, Long.MAX_VALUE);
    }

    FileBasedSnapshotChunkReader(Path directory, long maximumChunkSize) throws IOException {
        this.directory = directory;
        this.chunks = this.collectChunks(directory);
        this.totalCount = this.chunks.size();
        this.chunksView = new TreeSet<CharSequence>((SortedSet<CharSequence>)this.chunks);
        this.snapshotID = directory.getFileName().toString();
        this.maximumChunkSize = maximumChunkSize;
    }

    private NavigableSet<CharSequence> collectChunks(Path directory) throws IOException {
        TreeSet<CharSequence> set = new TreeSet<CharSequence>(CharSequence::compare);
        try (Stream<Path> stream = Files.list(directory).sorted();){
            stream.map(directory::relativize).map(Path::toString).forEach(set::add);
        }
        return set;
    }

    @Override
    public void reset() {
        this.chunksView = new TreeSet<CharSequence>((SortedSet<CharSequence>)this.chunks);
    }

    @Override
    public void seek(ByteBuffer id) {
        if (id == null) {
            return;
        }
        SnapshotChunkId chunkId = new SnapshotChunkId(id);
        this.offset = chunkId.offset();
        this.chunksView = new TreeSet<CharSequence>((SortedSet<CharSequence>)this.chunks.tailSet(chunkId.fileName(), true));
    }

    @Override
    public ByteBuffer nextId() {
        if (this.chunksView.isEmpty()) {
            return null;
        }
        return new SnapshotChunkId(((CharSequence)this.chunksView.first()).toString(), this.offset).id();
    }

    @Override
    public void setMaximumChunkSize(int maximumChunkSize) {
        this.maximumChunkSize = maximumChunkSize;
    }

    public void close() {
        this.chunks.clear();
        this.chunksView.clear();
    }

    @Override
    public boolean hasNext() {
        return !this.chunksView.isEmpty();
    }

    @Override
    public SnapshotChunk next() {
        SnapshotChunk snapshotChunk;
        String fileName = ((CharSequence)this.chunksView.first()).toString();
        String filePath = this.directory.resolve(fileName).toString();
        RandomAccessFile file = new RandomAccessFile(filePath, "r");
        try {
            long fileLength = file.length();
            long bytesToRead = Math.min(this.maximumChunkSize, fileLength - this.offset);
            byte[] buffer = new byte[(int)bytesToRead];
            file.seek(this.offset);
            file.readFully(buffer);
            long fileBlockPosition = this.offset;
            this.offset += bytesToRead;
            if (this.offset == fileLength) {
                this.offset = 0L;
                this.chunksView.pollFirst();
            }
            snapshotChunk = SnapshotChunkUtil.createSnapshotChunkFromFileChunk(this.snapshotID, this.totalCount, fileName, buffer, fileBlockPosition, fileLength);
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        file.close();
        return snapshotChunk;
    }
}

