/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.snapshots.CRC32CChecksumProvider;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.PersistedSnapshotListener;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.snapshots.RestorableSnapshotStore;
import io.camunda.zeebe.snapshots.SnapshotException;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedReceivedSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStoreImpl;
import io.camunda.zeebe.util.Either;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class FileBasedSnapshotStore
extends Actor
implements ConstructableSnapshotStore,
ReceivableSnapshotStore,
RestorableSnapshotStore {
    private final String actorName;
    private final int partitionId;
    private final FileBasedSnapshotStoreImpl snapshotStore;

    public FileBasedSnapshotStore(int brokerId, int partitionId, Path root, CRC32CChecksumProvider checksumProvider) {
        this.actorName = FileBasedSnapshotStore.buildActorName((String)"SnapshotStore", (int)partitionId);
        this.partitionId = partitionId;
        this.snapshotStore = new FileBasedSnapshotStoreImpl(brokerId, partitionId, root, checksumProvider, (ConcurrencyControl)this);
    }

    protected Map<String, String> createContext() {
        Map context = super.createContext();
        context.put("partitionId", Integer.toString(this.partitionId));
        return context;
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarting() {
        this.snapshotStore.start();
    }

    protected void onActorClosing() {
        this.snapshotStore.close();
    }

    @Override
    public boolean hasSnapshotId(String id) {
        return this.snapshotStore.hasSnapshotId(id);
    }

    @Override
    public Optional<PersistedSnapshot> getLatestSnapshot() {
        return this.snapshotStore.getLatestSnapshot();
    }

    @Override
    public ActorFuture<Set<PersistedSnapshot>> getAvailableSnapshots() {
        return this.snapshotStore.getAvailableSnapshots();
    }

    @Override
    public ActorFuture<Long> getCompactionBound() {
        return this.snapshotStore.getCompactionBound();
    }

    @Override
    public ActorFuture<Void> purgePendingSnapshots() {
        CompletableActorFuture abortFuture = new CompletableActorFuture();
        return this.snapshotStore.purgePendingSnapshots();
    }

    @Override
    public ActorFuture<Boolean> addSnapshotListener(PersistedSnapshotListener listener) {
        return this.snapshotStore.addSnapshotListener(listener);
    }

    @Override
    public ActorFuture<Boolean> removeSnapshotListener(PersistedSnapshotListener listener) {
        return this.snapshotStore.removeSnapshotListener(listener);
    }

    @Override
    public long getCurrentSnapshotIndex() {
        return this.snapshotStore.getCurrentSnapshotIndex();
    }

    @Override
    public ActorFuture<Void> delete() {
        return this.snapshotStore.delete();
    }

    @Override
    public Path getPath() {
        return this.snapshotStore.getPath();
    }

    public ActorFuture<FileBasedReceivedSnapshot> newReceivedSnapshot(String snapshotId) {
        return this.snapshotStore.newReceivedSnapshot(snapshotId);
    }

    @Override
    public Either<SnapshotException, TransientSnapshot> newTransientSnapshot(long index, long term, long processedPosition, long exportedPosition) {
        return this.snapshotStore.newTransientSnapshot(index, term, processedPosition, exportedPosition);
    }

    @Override
    public void restore(String snapshotId, Map<String, Path> snapshotFiles) throws IOException {
        this.snapshotStore.restore(snapshotId, snapshotFiles);
    }

    public String toString() {
        return "FileBasedSnapshotStore{actorName='" + this.actorName + "', partitionId=" + this.partitionId + ", snapshotStore=" + String.valueOf(this.snapshotStore) + "}";
    }
}

