/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.metrics;

import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public final class StreamProcessorMetrics {
    private static final String LABEL_NAME_PARTITION = "partition";
    private static final String LABEL_NAME_ACTION = "action";
    private static final String LABEL_WRITTEN = "written";
    private static final String LABEL_SKIPPED = "skipped";
    private static final String LABEL_PROCESSED = "processed";
    private static final String NAMESPACE = "zeebe";
    private static final Counter STREAM_PROCESSOR_EVENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("stream_processor_records_total")).help("Number of records processed by stream processor")).labelNames(new String[]{"action", "partition"})).register();
    private static final Gauge LAST_PROCESSED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("stream_processor_last_processed_position")).help("The last position the stream processor has processed.")).labelNames(new String[]{"partition"})).register();
    private static final Histogram PROCESSING_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("stream_processor_latency")).help("Time between a command is written until it is picked up for processing (in seconds)")).labelNames(new String[]{"partition"})).register();
    private static final String LABEL_NAME_VALUE_TYPE = "valueType";
    private static final String LABEL_NAME_INTENT = "intent";
    private static final Histogram PROCESSING_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("stream_processor_processing_duration")).help("Time for processing a record (in seconds)")).labelNames(new String[]{"partition", "valueType", "intent"})).register();
    private static final Gauge STARTUP_RECOVERY_TIME = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("stream_processor_startup_recovery_time")).help("Time taken for startup and recovery of stream processor (in ms)")).labelNames(new String[]{"partition"})).register();
    private static final Gauge PROCESSOR_STATE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("stream_processor_state")).help("Describes the state of the stream processor, namely if it is active or paused.")).labelNames(new String[]{"partition"})).register();
    private final String partitionIdLabel;
    private final Gauge.Child processorState;

    public StreamProcessorMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
        this.processorState = (Gauge.Child)PROCESSOR_STATE.labels(new String[]{this.partitionIdLabel});
    }

    public void setStreamProcessorInitial() {
        this.processorState.set(0.0);
    }

    public void setStreamProcessorReplay() {
        this.processorState.set(1.0);
    }

    public void setStreamProcessorProcessing() {
        this.processorState.set(2.0);
    }

    public void setStreamProcessorFailed() {
        this.processorState.set(3.0);
    }

    public void setStreamProcessorPaused() {
        this.processorState.set(4.0);
    }

    private void event(String action) {
        ((Counter.Child)STREAM_PROCESSOR_EVENTS.labels(new String[]{action, this.partitionIdLabel})).inc();
    }

    public void processingLatency(long written, long processed) {
        ((Histogram.Child)PROCESSING_LATENCY.labels(new String[]{this.partitionIdLabel})).observe((double)((float)(processed - written) / 1000.0f));
    }

    public Histogram.Timer startProcessingDurationTimer(ValueType valueType, Intent intent) {
        return ((Histogram.Child)PROCESSING_DURATION.labels(new String[]{this.partitionIdLabel, valueType.name(), intent.name()})).startTimer();
    }

    public void commandsProcessed() {
        this.event(LABEL_PROCESSED);
    }

    public void recordsWritten(long amount) {
        if (amount < 1L) {
            return;
        }
        ((Counter.Child)STREAM_PROCESSOR_EVENTS.labels(new String[]{LABEL_WRITTEN, this.partitionIdLabel})).inc((double)amount);
    }

    public void eventSkipped() {
        this.event(LABEL_SKIPPED);
    }

    public Gauge.Timer startRecoveryTimer() {
        return ((Gauge.Child)STARTUP_RECOVERY_TIME.labels(new String[]{this.partitionIdLabel})).startTimer();
    }

    public void setLastProcessedPosition(long position) {
        ((Gauge.Child)LAST_PROCESSED_POSITION.labels(new String[]{this.partitionIdLabel})).set((double)position);
    }

    public void initializeProcessorPhase(StreamProcessor.Phase phase) {
        switch (phase) {
            case INITIAL: {
                this.setStreamProcessorInitial();
                break;
            }
            case REPLAY: {
                this.setStreamProcessorReplay();
                break;
            }
            case PROCESSING: {
                this.setStreamProcessorProcessing();
                break;
            }
            case PAUSED: {
                this.setStreamProcessorPaused();
                break;
            }
            default: {
                this.setStreamProcessorFailed();
            }
        }
    }
}

